/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.vizjs;

import java.io.File;
import java.io.OutputStream;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import znaishaded.net.sourceforge.plantuml.dot.ExeState;
import znaishaded.net.sourceforge.plantuml.dot.Graphviz;
import znaishaded.net.sourceforge.plantuml.dot.GraphvizVersion;
import znaishaded.net.sourceforge.plantuml.dot.ProcessState;
import znaishaded.net.sourceforge.plantuml.log.Logme;
import znaishaded.net.sourceforge.plantuml.vizjs.GraphvizJsRuntimeException;
import znaishaded.net.sourceforge.plantuml.vizjs.VizJsEngine;

public class GraphvizJs
implements Graphviz {
    private static final ExecutorService executorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable runnable) {
            return new JsThread(runnable);
        }
    });
    private final String dotString;

    public GraphvizJs(String dotString) {
        this.dotString = dotString;
    }

    @Override
    public ProcessState createFile3(OutputStream os) {
        try {
            String svg = this.submitJob().get();
            os.write(svg.getBytes());
            return ProcessState.TERMINATED_OK();
        }
        catch (Exception e) {
            Logme.error(e);
            throw new GraphvizJsRuntimeException(e);
        }
    }

    private Future<String> submitJob() {
        return executorService.submit(new Callable<String>(){

            @Override
            public String call() throws Exception {
                JsThread th = (JsThread)Thread.currentThread();
                VizJsEngine engine = th.engine;
                return engine.execute(GraphvizJs.this.dotString);
            }
        });
    }

    @Override
    public File getDotExe() {
        return null;
    }

    @Override
    public String dotVersion() {
        return "VizJs";
    }

    @Override
    public ExeState getExeState() {
        return ExeState.OK;
    }

    public static GraphvizVersion getGraphvizVersion(final boolean modeSafe) {
        return new GraphvizVersion(){

            @Override
            public boolean useShieldForQuantifier() {
                return true;
            }

            @Override
            public boolean useProtectionWhenThereALinkFromOrToGroup() {
                return true;
            }

            @Override
            public boolean useXLabelInsteadOfLabel() {
                return modeSafe;
            }

            @Override
            public boolean isVizjs() {
                return true;
            }

            @Override
            public boolean ignoreHorizontalLinks() {
                return false;
            }
        };
    }

    @Override
    public boolean graphviz244onWindows() {
        return false;
    }

    static class JsThread
    extends Thread {
        private final Runnable runnable;
        private VizJsEngine engine;

        public JsThread(Runnable runnable) {
            this.runnable = runnable;
        }

        @Override
        public void run() {
            if (this.engine == null) {
                try {
                    this.engine = new VizJsEngine();
                }
                catch (Exception e) {
                    Logme.error(e);
                }
            }
            this.runnable.run();
        }
    }
}

