/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.java.extensions;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.testingisdocumenting.znai.extensions.PluginParamType;
import org.testingisdocumenting.znai.extensions.PluginParamsDefinition;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.api.ApiLinkedText;
import org.testingisdocumenting.znai.extensions.api.ApiParameters;
import org.testingisdocumenting.znai.extensions.file.CodeReferencesFeature;
import org.testingisdocumenting.znai.extensions.include.IncludePlugin;
import org.testingisdocumenting.znai.java.extensions.JavaDocMarkdownParameter;
import org.testingisdocumenting.znai.java.extensions.JavaIncludePluginBase;
import org.testingisdocumenting.znai.java.extensions.JavaIncludeResult;
import org.testingisdocumenting.znai.java.parser.JavaCode;
import org.testingisdocumenting.znai.java.parser.JavaMethod;
import org.testingisdocumenting.znai.java.parser.JavaMethodReturn;
import org.testingisdocumenting.znai.parser.docelement.DocElement;

public class JavaDocParamsIncludePlugin
extends JavaIncludePluginBase {
    private CodeReferencesFeature codeReferencesFeature;

    @Override
    public String id() {
        return "java-doc-params";
    }

    @Override
    public IncludePlugin create() {
        return new JavaDocParamsIncludePlugin();
    }

    @Override
    public PluginParamsDefinition parameters() {
        return new PluginParamsDefinition().addRequired("entry", PluginParamType.STRING, "entry to extract parameters definition from", "\"myMethod\"").add("title", PluginParamType.STRING, "title to use for parameters block", "\"myMethod parameters\"").add(JavaDocMarkdownParameter.definition).add(CodeReferencesFeature.paramsDefinition);
    }

    @Override
    public JavaIncludeResult process(JavaCode javaCode) {
        this.codeReferencesFeature = new CodeReferencesFeature(this.componentsRegistry, this.markupPath, this.pluginParams);
        this.features.add(this.codeReferencesFeature);
        JavaMethod javaMethod = javaCode.findMethod((String)this.entries.get(0));
        ApiParameters apiParameters = new ApiParameters(javaMethod.getAnchorPrefix());
        this.addReturn(apiParameters, javaMethod);
        javaMethod.getParams().forEach(param -> {
            JavaIncludePluginBase.JavaDocElementsMapsAndSearchText docElementsMapsAndSearchText = this.javaDocTextToDocElements(param.getJavaDocText(), this.codeReferencesFeature);
            apiParameters.add(param.getName(), new ApiLinkedText(param.getType()), docElementsMapsAndSearchText.docElementsMaps, docElementsMapsAndSearchText.searchText);
        });
        Map<String, Object> props = apiParameters.toMap();
        this.features.updateProps(props);
        props.putAll(this.pluginParams.getOpts().toMap());
        List<DocElement> docElements = PluginResult.docElement("ApiParameters", props).getDocElements();
        return new JavaIncludeResult(docElements, this.extractText(javaMethod));
    }

    private String extractText(JavaMethod javaMethod) {
        JavaMethodReturn methodReturn = javaMethod.getJavaMethodReturn();
        String returnPart = methodReturn != null ? "return " + methodReturn.getType() + " " + methodReturn.getJavaDocText() : "";
        String paramsPart = javaMethod.getParams().stream().map(p -> p.getName() + " " + p.getType() + " " + p.getJavaDocText()).collect(Collectors.joining(" "));
        return paramsPart + (returnPart.isEmpty() ? "" : " ") + returnPart;
    }

    private void addReturn(ApiParameters apiParameters, JavaMethod javaMethod) {
        JavaMethodReturn methodReturn = javaMethod.getJavaMethodReturn();
        if (methodReturn == null) {
            return;
        }
        JavaIncludePluginBase.JavaDocElementsMapsAndSearchText elementsMapsAndSearchText = this.javaDocTextToDocElements(methodReturn.getJavaDocText(), this.codeReferencesFeature);
        apiParameters.add("return", new ApiLinkedText(methodReturn.getType()), elementsMapsAndSearchText.docElementsMaps, elementsMapsAndSearchText.searchText);
    }
}

