/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.markdown;

import java.util.List;
import java.util.Map;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.fence.FencePlugin;
import org.testingisdocumenting.znai.extensions.footnote.FootnoteId;
import org.testingisdocumenting.znai.extensions.footnote.ParsedFootnote;
import org.testingisdocumenting.znai.extensions.include.IncludePlugin;
import org.testingisdocumenting.znai.extensions.inlinedcode.InlinedCodePlugin;
import org.testingisdocumenting.znai.parser.HeadingProps;
import org.testingisdocumenting.znai.parser.ParserHandler;
import org.testingisdocumenting.znai.parser.docelement.DocElement;
import org.testingisdocumenting.znai.parser.table.MarkupTableData;
import org.testingisdocumenting.znai.reference.DocReferences;
import znaishaded.org.commonmark.node.Heading;
import znaishaded.org.jsoup.Jsoup;

public class MarkdownGeneratorParserHandler
implements ParserHandler {
    private final StringBuilder markdown;
    private final int baseHeadingLevel;
    private State state = State.DEFAULT;

    public MarkdownGeneratorParserHandler(int baseHeadingLevel) {
        this.markdown = new StringBuilder();
        this.baseHeadingLevel = baseHeadingLevel;
    }

    public String getMarkdown() {
        return this.markdown.toString().replaceAll("\n\n\n", "\n\n");
    }

    @Override
    public void onSectionStart(String title, HeadingProps headingProps, Heading heading) {
        if (heading == null) {
            return;
        }
        int level = Math.max(1, heading.getLevel() + this.baseHeadingLevel);
        this.markdown.append("#".repeat(level)).append(" ").append(title).append("\n\n");
    }

    @Override
    public void onSubHeading(int level, String title, HeadingProps headingProps, Heading heading) {
        int adjustedLevel = Math.max(1, level + this.baseHeadingLevel);
        this.markdown.append("#".repeat(adjustedLevel)).append(" ").append(title).append("\n\n");
    }

    @Override
    public void onSimpleText(String value) {
        this.markdown.append(value);
    }

    @Override
    public void onParagraphStart() {
    }

    @Override
    public void onParagraphEnd() {
        switch (this.state) {
            case INSIDE_LIST: {
                this.markdown.append("\n");
                break;
            }
            case DEFAULT: {
                this.markdown.append("\n\n");
            }
        }
    }

    @Override
    public void onInlinedCode(String inlinedCode, DocReferences docReferences) {
        this.markdown.append("`").append(inlinedCode).append("`");
    }

    @Override
    public void onEmphasisStart() {
        this.markdown.append("*");
    }

    @Override
    public void onEmphasisEnd() {
        this.markdown.append("*");
    }

    @Override
    public void onStrongEmphasisStart() {
        this.markdown.append("**");
    }

    @Override
    public void onStrongEmphasisEnd() {
        this.markdown.append("**");
    }

    @Override
    public void onStrikeThroughStart() {
        this.markdown.append("~~");
    }

    @Override
    public void onStrikeThroughEnd() {
        this.markdown.append("~~");
    }

    @Override
    public void onListItemStart() {
        this.markdown.append("- ");
    }

    @Override
    public void onListItemEnd() {
    }

    @Override
    public void onBulletListStart(char bulletMarker, boolean tight) {
        this.state = State.INSIDE_LIST;
    }

    @Override
    public void onBulletListEnd() {
        this.state = State.DEFAULT;
        this.markdown.append("\n");
    }

    @Override
    public void onOrderedListStart(char delimiter, int startNumber) {
        this.state = State.INSIDE_LIST;
    }

    @Override
    public void onOrderedListEnd() {
        this.state = State.DEFAULT;
        this.markdown.append("\n");
    }

    @Override
    public void onBlockQuoteStart() {
        this.markdown.append("> ");
    }

    @Override
    public void onBlockQuoteEnd() {
        this.markdown.append("\n");
    }

    @Override
    public void onImage(String title, String destination, String alt) {
        this.markdown.append("![").append(alt != null ? alt : "").append("](").append(destination);
        if (title != null && !title.trim().isEmpty()) {
            this.markdown.append(" \"").append(title).append("\"");
        }
        this.markdown.append(")\n\n");
    }

    @Override
    public void onSnippet(PluginParams pluginParams, String lang, String lineNumber, String snippet) {
        this.markdown.append("```").append(lang != null ? lang : "").append("\n");
        this.markdown.append(snippet);
        if (!snippet.endsWith("\n")) {
            this.markdown.append("\n");
        }
        this.markdown.append("```\n\n");
    }

    @Override
    public void onTable(MarkupTableData tableData) {
        List<String> columnTitles = tableData.getColumnTitles();
        List<List<Object>> data = tableData.getData();
        if (columnTitles.isEmpty()) {
            return;
        }
        this.markdown.append("| ").append(String.join((CharSequence)" | ", columnTitles)).append(" |\n");
        this.markdown.append("|").append(" --- |".repeat(columnTitles.size())).append("\n");
        for (List<Object> row : data) {
            this.markdown.append("| ");
            for (int i = 0; i < columnTitles.size(); ++i) {
                String cell = i < row.size() && row.get(i) != null ? row.get(i).toString() : "";
                this.markdown.append(cell.replace("|", "\\|"));
                if (i >= columnTitles.size() - 1) continue;
                this.markdown.append(" | ");
            }
            this.markdown.append(" |\n");
        }
        this.markdown.append("\n\n");
    }

    @Override
    public void onFootnoteDefinition(ParsedFootnote footnote) {
        this.markdown.append("[^").append(footnote.id().id()).append("]: ").append(footnote.allText()).append("\n\n");
    }

    @Override
    public void onSoftLineBreak() {
        this.markdown.append(" ");
    }

    @Override
    public void onHardLineBreak() {
        this.markdown.append("  \n");
    }

    @Override
    public void onThematicBreak() {
        this.markdown.append("---\n\n");
    }

    @Override
    public void onHtml(String html, boolean isInlined) {
        String plainText = Jsoup.parse(html).text();
        if (!plainText.isEmpty()) {
            this.markdown.append(plainText);
            if (!isInlined) {
                this.markdown.append("\n\n");
            }
        }
    }

    @Override
    public void onParsingEnd() {
    }

    @Override
    public void onSectionEnd() {
    }

    @Override
    public void onLinkStart(String url) {
        this.markdown.append("[");
    }

    @Override
    public void onLinkEnd() {
        this.markdown.append("]()");
    }

    @Override
    public void onFootnoteReference(FootnoteId footnoteId) {
        this.markdown.append("[^").append(footnoteId.id()).append("]");
    }

    @Override
    public void onCustomNodeStart(String nodeName, Map<String, ?> attrs) {
    }

    @Override
    public void onCustomNode(String nodeName, Map<String, ?> attrs) {
    }

    @Override
    public void onCustomNodeEnd(String nodeName) {
    }

    @Override
    public void onDocElement(DocElement docElement) {
    }

    @Override
    public void onGlobalAnchor(String id) {
    }

    @Override
    public void onGlobalAnchorRefStart(String id) {
    }

    @Override
    public void onGlobalAnchorRefEnd() {
    }

    @Override
    public void onIncludePlugin(IncludePlugin includePlugin, PluginResult pluginResult) {
        String markdownRepresentation = includePlugin.markdownRepresentation();
        this.markdown.append(markdownRepresentation).append("\n\n");
    }

    @Override
    public void onFencePlugin(FencePlugin fencePlugin, PluginResult pluginResult) {
        String markdownRepresentation = fencePlugin.markdownRepresentation();
        this.markdown.append(markdownRepresentation).append("\n\n");
    }

    @Override
    public void onInlinedCodePlugin(InlinedCodePlugin inlinedCodePlugin, PluginResult pluginResult) {
        String markdownRepresentation = inlinedCodePlugin.markdownRepresentation();
        this.markdown.append(markdownRepresentation);
    }

    static enum State {
        INSIDE_LIST,
        DEFAULT;

    }
}

