/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.fence.FencePlugin;
import org.testingisdocumenting.znai.extensions.footnote.ParsedFootnote;
import org.testingisdocumenting.znai.extensions.include.IncludePlugin;
import org.testingisdocumenting.znai.parser.HeadingProps;
import org.testingisdocumenting.znai.parser.NoOpParserHandler;
import org.testingisdocumenting.znai.parser.PageSectionIdTitle;
import org.testingisdocumenting.znai.parser.table.MarkupTableData;
import org.testingisdocumenting.znai.reference.DocReferences;
import org.testingisdocumenting.znai.search.PageSearchEntry;
import org.testingisdocumenting.znai.search.SearchScore;
import org.testingisdocumenting.znai.search.SearchText;
import znaishaded.org.commonmark.node.Heading;
import znaishaded.org.jsoup.Jsoup;

public class SearchCrawlerParserHandler
extends NoOpParserHandler {
    private final List<PageSearchEntry> searchEntries = new ArrayList<PageSearchEntry>();
    private PageSectionIdTitle pageSectionIdTitle = new PageSectionIdTitle("", Collections.emptyMap());
    private final List<String> standardScoreParts = new ArrayList<String>();
    private final List<String> highScoreParts = new ArrayList<String>();

    public List<PageSearchEntry> getSearchEntries() {
        return this.searchEntries;
    }

    @Override
    public void onSectionStart(String title, HeadingProps headingProps, Heading heading) {
        this.flush();
        this.pageSectionIdTitle = new PageSectionIdTitle(title, headingProps.props());
    }

    @Override
    public void onSectionEnd() {
        this.flush();
    }

    @Override
    public void onSubHeading(int level, String title, HeadingProps headingProps, Heading heading) {
        this.addStandardWithSpaceSeparator(title);
    }

    @Override
    public void onTable(MarkupTableData tableData) {
        this.addStandardWithSpaceSeparator(tableData.allText());
    }

    @Override
    public void onFootnoteDefinition(ParsedFootnote footnote) {
        this.addStandardWithSpaceSeparator(footnote.allText());
    }

    @Override
    public void onSimpleText(String value) {
        this.addStandard(this.replaceCommonSeparatorsWithSpace(value));
    }

    @Override
    public void onParagraphEnd() {
        this.addStandard(" ");
    }

    @Override
    public void onInlinedCode(String inlinedCode, DocReferences docReferences) {
        this.addHighWithSpaceSeparator(this.replaceCommonSeparatorsWithSpace(inlinedCode));
    }

    @Override
    public void onImage(String title, String destination, String alt) {
        this.addStandardWithSpaceSeparator(title);
        this.addStandardWithSpaceSeparator(alt);
    }

    @Override
    public void onSnippet(PluginParams pluginParams, String lang, String lineNumber, String snippet) {
        this.addHighWithSpaceSeparator(snippet);
    }

    @Override
    public void onIncludePlugin(IncludePlugin includePlugin, PluginResult pluginResult) {
        this.processPluginSearchText(includePlugin.textForSearch());
    }

    @Override
    public void onFencePlugin(FencePlugin fencePlugin, PluginResult pluginResult) {
        this.processPluginSearchText(fencePlugin.textForSearch());
    }

    @Override
    public void onSoftLineBreak() {
        this.addStandard(" ");
    }

    @Override
    public void onHardLineBreak() {
        this.addStandard(" ");
    }

    @Override
    public void onListItemEnd() {
        this.addStandard(" ");
    }

    @Override
    public void onHtml(String html, boolean isInlined) {
        this.addStandard(Jsoup.parse(html).text());
    }

    @Override
    public void onParsingEnd() {
        this.flush();
    }

    private void flush() {
        this.flushTextParts();
    }

    private void processPluginSearchText(SearchText searchText) {
        if (searchText == null) {
            return;
        }
        switch (searchText.getScore()) {
            case HIGH: {
                this.addHighWithSpaceSeparator(searchText.getText());
                break;
            }
            case STANDARD: {
                this.addStandardWithSpaceSeparator(searchText.getText());
            }
        }
    }

    private void addStandard(String part) {
        this.standardScoreParts.add(part);
    }

    private void addStandardWithSpaceSeparator(String part) {
        if (part == null) {
            return;
        }
        this.standardScoreParts.add(" " + this.replaceCommonSeparatorsWithSpace(part) + " ");
    }

    private void addHighWithSpaceSeparator(String part) {
        if (part == null) {
            return;
        }
        this.highScoreParts.add(" " + this.replaceCommonSeparatorsWithSpace(part) + " ");
    }

    private String replaceCommonSeparatorsWithSpace(String text) {
        return text.replaceAll("[.,();:\\-+=\\\\/\"'!?\\[\\]{}~]", " ");
    }

    private SearchText createSearchText(SearchScore score, List<String> parts) {
        return new SearchText(score, String.join((CharSequence)"", parts).replaceAll("\\s+", " ").trim());
    }

    private void flushTextParts() {
        if (this.standardScoreParts.isEmpty() && this.highScoreParts.isEmpty()) {
            return;
        }
        this.searchEntries.add(new PageSearchEntry(this.pageSectionIdTitle, List.of(this.createSearchText(SearchScore.STANDARD, this.standardScoreParts), this.createSearchText(SearchScore.HIGH, this.highScoreParts))));
        this.standardScoreParts.clear();
        this.highScoreParts.clear();
    }
}

