/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.server;

import znaishaded.io.vertx.core.http.HttpServerOptions;
import znaishaded.io.vertx.core.net.JksOptions;
import znaishaded.io.vertx.core.net.PemKeyCertOptions;

public record SslConfig(String jksPath, String jksPassword, String pemCertPath, String pemKeyPath) {
    public boolean isSpecified() {
        return this.jksPath != null && this.jksPassword != null || this.pemCertPath != null && this.pemKeyPath != null;
    }

    public void updateServerOptions(HttpServerOptions serverOptions) {
        if (!this.isSpecified()) {
            return;
        }
        serverOptions.setSsl(true);
        if (this.jksPath != null) {
            serverOptions.setKeyStoreOptions(new JksOptions().setPath(this.jksPath()).setPassword(this.jksPassword()));
        } else {
            serverOptions.setPemKeyCertOptions(new PemKeyCertOptions().setCertPath(this.pemCertPath).setKeyPath(this.pemKeyPath));
        }
    }
}

