/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.utils;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import znaishaded.org.apache.commons.io.IOUtils;

public class ResourceUtils {
    private ResourceUtils() {
    }

    public static InputStream requiredResourceStream(String resourcePath) {
        InputStream stream = ResourceUtils.resourceStream(resourcePath);
        if (stream == null) {
            throw new RuntimeException("can't find resource: " + resourcePath);
        }
        return stream;
    }

    public static InputStream resourceStream(String resourcePath) {
        return ResourceUtils.class.getClassLoader().getResourceAsStream(resourcePath);
    }

    public static String textContent(String resourcePath) {
        InputStream stream = ResourceUtils.requiredResourceStream(resourcePath);
        try {
            return IOUtils.toString(stream, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] binaryContent(String resourcePath) {
        InputStream stream = ResourceUtils.requiredResourceStream(resourcePath);
        try {
            return IOUtils.toByteArray(stream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<String> textContents(String resourcePath) {
        ArrayList<String> contents = new ArrayList<String>();
        try {
            Enumeration<URL> resources = ResourceUtils.class.getClassLoader().getResources(resourcePath);
            while (resources.hasMoreElements()) {
                contents.add(IOUtils.toString(resources.nextElement(), StandardCharsets.UTF_8));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (contents.isEmpty()) {
            throw new IllegalArgumentException("can't find resource: " + resourcePath);
        }
        return contents;
    }

    public static Path tempCopyOfResource(String resourcePath) {
        String textContent = ResourceUtils.textContent(resourcePath);
        try {
            Path path = Files.createTempFile(Paths.get(resourcePath, new String[0]).getFileName().toString(), "", new FileAttribute[0]);
            path.toFile().deleteOnExit();
            Files.write(path, textContent.getBytes(), new OpenOption[0]);
            return path;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

