/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.com.github.fge.jsonschema.core.util;

import javax.annotation.concurrent.Immutable;
import znaishaded.com.fasterxml.jackson.databind.JsonNode;
import znaishaded.com.fasterxml.jackson.databind.node.JsonNodeFactory;
import znaishaded.com.github.fge.jackson.JacksonUtils;
import znaishaded.com.github.fge.jsonschema.core.report.MessageProvider;
import znaishaded.com.github.fge.jsonschema.core.report.ProcessingMessage;
import znaishaded.com.github.fge.jsonschema.core.util.AsJson;
import znaishaded.com.github.fge.jsonschema.core.util.AsJsonValueHolder;
import znaishaded.com.github.fge.jsonschema.core.util.SimpleValueHolder;

@Immutable
public abstract class ValueHolder<T>
implements MessageProvider {
    protected static final JsonNodeFactory FACTORY = JacksonUtils.nodeFactory();
    private final String name;
    protected final T value;

    public static <V> ValueHolder<V> hold(V value) {
        return new SimpleValueHolder<V>("value", value);
    }

    public static <V> ValueHolder<V> hold(String name, V value) {
        return new SimpleValueHolder<V>(name, value);
    }

    public static <V extends AsJson> ValueHolder<V> hold(V value) {
        return new AsJsonValueHolder<V>("value", value);
    }

    public static <V extends AsJson> ValueHolder<V> hold(String name, V value) {
        return new AsJsonValueHolder<V>(name, value);
    }

    protected ValueHolder(String name, T value) {
        this.name = name;
        this.value = value;
    }

    protected abstract JsonNode valueAsJson();

    public final String getName() {
        return this.name;
    }

    public final T getValue() {
        return this.value;
    }

    @Override
    public final ProcessingMessage newMessage() {
        return new ProcessingMessage().put(this.name, this.valueAsJson());
    }
}

