/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.freemarker.core;

import java.util.Collections;
import java.util.List;
import znaishaded.freemarker.core.BugException;
import znaishaded.freemarker.core.BuiltInWithParseTimeParameters;
import znaishaded.freemarker.core.Environment;
import znaishaded.freemarker.core.Expression;
import znaishaded.freemarker.core.ExpressionWithFixedResult;
import znaishaded.freemarker.core.LazilyGeneratedCollectionModel;
import znaishaded.freemarker.core.LazyCollectionTemplateModelIterator;
import znaishaded.freemarker.core.LazySequenceIterator;
import znaishaded.freemarker.core.LocalLambdaExpression;
import znaishaded.freemarker.core.Macro;
import znaishaded.freemarker.core.NonMethodException;
import znaishaded.freemarker.core.NonSequenceOrCollectionException;
import znaishaded.freemarker.core.ParseException;
import znaishaded.freemarker.core.Token;
import znaishaded.freemarker.template.TemplateCollectionModel;
import znaishaded.freemarker.template.TemplateException;
import znaishaded.freemarker.template.TemplateMethodModel;
import znaishaded.freemarker.template.TemplateModel;
import znaishaded.freemarker.template.TemplateModelException;
import znaishaded.freemarker.template.TemplateModelIterator;
import znaishaded.freemarker.template.TemplateSequenceModel;

abstract class IntermediateStreamOperationLikeBuiltIn
extends BuiltInWithParseTimeParameters {
    private Expression elementTransformerExp;
    private ElementTransformer precreatedElementTransformer;
    private boolean lazilyGeneratedResultEnabled;

    IntermediateStreamOperationLikeBuiltIn() {
    }

    @Override
    void bindToParameters(List<Expression> parameters, Token openParen, Token closeParen) throws ParseException {
        if (parameters.size() != 1) {
            throw this.newArgumentCountException("requires exactly 1", openParen, closeParen);
        }
        Expression elementTransformerExp = parameters.get(0);
        this.setElementTransformerExp(elementTransformerExp);
    }

    private void setElementTransformerExp(Expression elementTransformerExp) throws ParseException {
        this.elementTransformerExp = elementTransformerExp;
        if (this.elementTransformerExp instanceof LocalLambdaExpression) {
            LocalLambdaExpression localLambdaExp = (LocalLambdaExpression)this.elementTransformerExp;
            this.checkLocalLambdaParamCount(localLambdaExp, 1);
            this.precreatedElementTransformer = new LocalLambdaElementTransformer(localLambdaExp);
        }
    }

    @Override
    protected final boolean isLocalLambdaParameterSupported() {
        return true;
    }

    @Override
    final void enableLazilyGeneratedResult() {
        this.lazilyGeneratedResultEnabled = true;
    }

    protected final boolean isLazilyGeneratedResultEnabled() {
        return this.lazilyGeneratedResultEnabled;
    }

    @Override
    protected void setTarget(Expression target) {
        super.setTarget(target);
        target.enableLazilyGeneratedResult();
    }

    @Override
    protected List<Expression> getArgumentsAsList() {
        return Collections.singletonList(this.elementTransformerExp);
    }

    @Override
    protected int getArgumentsCount() {
        return 1;
    }

    @Override
    protected Expression getArgumentParameterValue(int argIdx) {
        if (argIdx != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.elementTransformerExp;
    }

    protected Expression getElementTransformerExp() {
        return this.elementTransformerExp;
    }

    @Override
    protected void cloneArguments(Expression clone, String replacedIdentifier, Expression replacement, Expression.ReplacemenetState replacementState) {
        try {
            ((IntermediateStreamOperationLikeBuiltIn)clone).setElementTransformerExp(this.elementTransformerExp.deepCloneWithIdentifierReplaced(replacedIdentifier, replacement, replacementState));
        }
        catch (ParseException e) {
            throw new BugException("Deep-clone elementTransformerExp failed", e);
        }
    }

    @Override
    TemplateModel _eval(Environment env) throws TemplateException {
        boolean targetIsSequence;
        TemplateModelIterator targetIterator;
        TemplateModel targetValue = this.target.eval(env);
        if (targetValue instanceof TemplateCollectionModel) {
            targetIterator = this.isLazilyGeneratedResultEnabled() ? new LazyCollectionTemplateModelIterator((TemplateCollectionModel)targetValue) : ((TemplateCollectionModel)targetValue).iterator();
            targetIsSequence = targetValue instanceof LazilyGeneratedCollectionModel ? ((LazilyGeneratedCollectionModel)targetValue).isSequence() : targetValue instanceof TemplateSequenceModel;
        } else if (targetValue instanceof TemplateSequenceModel) {
            targetIterator = new LazySequenceIterator((TemplateSequenceModel)targetValue);
            targetIsSequence = true;
        } else {
            throw new NonSequenceOrCollectionException(this.target, targetValue, env);
        }
        return this.calculateResult(targetIterator, targetValue, targetIsSequence, this.evalElementTransformerExp(env), env);
    }

    private ElementTransformer evalElementTransformerExp(Environment env) throws TemplateException {
        if (this.precreatedElementTransformer != null) {
            return this.precreatedElementTransformer;
        }
        TemplateModel elementTransformerModel = this.elementTransformerExp.eval(env);
        if (elementTransformerModel instanceof TemplateMethodModel) {
            return new MethodElementTransformer((TemplateMethodModel)elementTransformerModel);
        }
        if (elementTransformerModel instanceof Macro) {
            return new FunctionElementTransformer((Macro)elementTransformerModel, this.elementTransformerExp);
        }
        throw new NonMethodException(this.elementTransformerExp, elementTransformerModel, true, true, null, env);
    }

    protected abstract TemplateModel calculateResult(TemplateModelIterator var1, TemplateModel var2, boolean var3, ElementTransformer var4, Environment var5) throws TemplateException;

    private static class FunctionElementTransformer
    implements ElementTransformer {
        private final Macro templateTransformer;
        private final Expression elementTransformerExp;

        public FunctionElementTransformer(Macro templateTransformer, Expression elementTransformerExp) {
            this.templateTransformer = templateTransformer;
            this.elementTransformerExp = elementTransformerExp;
        }

        @Override
        public TemplateModel transformElement(TemplateModel element, Environment env) throws TemplateException {
            ExpressionWithFixedResult functionArgExp = new ExpressionWithFixedResult(element, this.elementTransformerExp);
            return env.invokeFunction(env, this.templateTransformer, Collections.singletonList(functionArgExp), this.elementTransformerExp);
        }
    }

    private static class MethodElementTransformer
    implements ElementTransformer {
        private final TemplateMethodModel elementTransformer;

        public MethodElementTransformer(TemplateMethodModel elementTransformer) {
            this.elementTransformer = elementTransformer;
        }

        @Override
        public TemplateModel transformElement(TemplateModel element, Environment env) throws TemplateModelException {
            Object result = this.elementTransformer.exec(Collections.singletonList(element));
            return result instanceof TemplateModel ? (TemplateModel)result : env.getObjectWrapper().wrap(result);
        }
    }

    private static class LocalLambdaElementTransformer
    implements ElementTransformer {
        private final LocalLambdaExpression elementTransformerExp;

        public LocalLambdaElementTransformer(LocalLambdaExpression elementTransformerExp) {
            this.elementTransformerExp = elementTransformerExp;
        }

        @Override
        public TemplateModel transformElement(TemplateModel element, Environment env) throws TemplateException {
            return this.elementTransformerExp.invokeLambdaDefinedFunction(element, env);
        }
    }

    static interface ElementTransformer {
        public TemplateModel transformElement(TemplateModel var1, Environment var2) throws TemplateException;
    }
}

