/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.swagger.v3.parser.processors;

import java.util.List;
import java.util.Map;
import znaishaded.io.swagger.v3.oas.models.OpenAPI;
import znaishaded.io.swagger.v3.oas.models.Operation;
import znaishaded.io.swagger.v3.oas.models.PathItem;
import znaishaded.io.swagger.v3.oas.models.callbacks.Callback;
import znaishaded.io.swagger.v3.oas.models.parameters.Parameter;
import znaishaded.io.swagger.v3.oas.models.parameters.RequestBody;
import znaishaded.io.swagger.v3.oas.models.responses.ApiResponse;
import znaishaded.io.swagger.v3.oas.models.responses.ApiResponses;
import znaishaded.io.swagger.v3.parser.ResolverCache;
import znaishaded.io.swagger.v3.parser.models.RefFormat;
import znaishaded.io.swagger.v3.parser.processors.ExternalRefProcessor;
import znaishaded.io.swagger.v3.parser.processors.ParameterProcessor;
import znaishaded.io.swagger.v3.parser.processors.RequestBodyProcessor;
import znaishaded.io.swagger.v3.parser.processors.ResponseProcessor;
import znaishaded.io.swagger.v3.parser.util.RefUtils;

public class OperationProcessor {
    private final ParameterProcessor parameterProcessor;
    private final RequestBodyProcessor requestBodyProcessor;
    private final ResponseProcessor responseProcessor;
    private final ExternalRefProcessor externalRefProcessor;
    private final ResolverCache cache;

    public OperationProcessor(ResolverCache cache, OpenAPI openAPI) {
        this(cache, openAPI, false);
    }

    public OperationProcessor(ResolverCache cache, OpenAPI openAPI, boolean openapi31) {
        this.parameterProcessor = new ParameterProcessor(cache, openAPI, openapi31);
        this.responseProcessor = new ResponseProcessor(cache, openAPI, openapi31);
        this.requestBodyProcessor = new RequestBodyProcessor(cache, openAPI, openapi31);
        this.externalRefProcessor = new ExternalRefProcessor(cache, openAPI);
        this.cache = cache;
    }

    public void processOperation(Operation operation) {
        Map<String, Callback> callbacks;
        ApiResponses responses;
        Object requestBody;
        List<Parameter> processedOperationParameters;
        if (operation.getParameters() != null) {
            for (Parameter parameter : operation.getParameters()) {
                this.parameterProcessor.processParameter(parameter);
            }
        }
        if ((processedOperationParameters = this.parameterProcessor.processParameters(operation.getParameters())) != null) {
            operation.setParameters(processedOperationParameters);
        }
        if ((requestBody = operation.getRequestBody()) != null) {
            if (((RequestBody)requestBody).get$ref() != null && this.cache != null && this.cache.getParseOptions() != null && this.cache.getParseOptions().isResolveRequestBody()) {
                this.requestBodyProcessor.processRequestBody((RequestBody)requestBody);
                RefFormat refFormat = RefUtils.computeRefFormat(((RequestBody)requestBody).get$ref());
                RequestBody resolvedRequestBody = this.cache.loadRef(((RequestBody)requestBody).get$ref(), refFormat, RequestBody.class);
                if (resolvedRequestBody != null) {
                    requestBody = resolvedRequestBody;
                    operation.setRequestBody(resolvedRequestBody);
                }
            }
            this.requestBodyProcessor.processRequestBody((RequestBody)requestBody);
        }
        if ((responses = operation.getResponses()) != null) {
            for (String responseCode : responses.keySet()) {
                ApiResponse response = (ApiResponse)responses.get(responseCode);
                if (response == null) continue;
                if (response.get$ref() != null && this.cache != null && this.cache.getParseOptions() != null && this.cache.getParseOptions().isResolveResponses()) {
                    this.responseProcessor.processResponse(response);
                    RefFormat refFormat = RefUtils.computeRefFormat(response.get$ref());
                    ApiResponse resolvedResponse = this.cache.loadRef(response.get$ref(), refFormat, ApiResponse.class);
                    if (resolvedResponse != null) {
                        response = resolvedResponse;
                        responses.put(responseCode, resolvedResponse);
                    }
                }
                this.responseProcessor.processResponse(response);
            }
        }
        if ((callbacks = operation.getCallbacks()) != null) {
            for (String name : callbacks.keySet()) {
                String newRef;
                String $ref;
                RefFormat refFormat;
                Callback callback = callbacks.get(name);
                if (callback == null) continue;
                if (callback.get$ref() != null && RefUtils.isAnExternalRefFormat(refFormat = RefUtils.computeRefFormat($ref = callback.get$ref())) && (newRef = this.externalRefProcessor.processRefToExternalCallback($ref, refFormat)) != null) {
                    callback.set$ref(newRef);
                }
                for (String callbackName : callback.keySet()) {
                    PathItem pathItem = (PathItem)callback.get(callbackName);
                    Map<PathItem.HttpMethod, Operation> operationMap = pathItem.readOperationsMap();
                    for (PathItem.HttpMethod httpMethod : operationMap.keySet()) {
                        Operation op = operationMap.get((Object)httpMethod);
                        this.processOperation(op);
                    }
                    List<Parameter> parameters = pathItem.getParameters();
                    if (parameters == null) continue;
                    for (Parameter parameter : parameters) {
                        this.parameterProcessor.processParameter(parameter);
                    }
                }
            }
        }
    }
}

