/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.core.json;

import java.io.IOException;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import znaishaded.com.fasterxml.jackson.core.JsonParser;
import znaishaded.com.fasterxml.jackson.core.JsonProcessingException;
import znaishaded.com.fasterxml.jackson.databind.DeserializationContext;
import znaishaded.com.fasterxml.jackson.databind.JsonDeserializer;
import znaishaded.com.fasterxml.jackson.databind.exc.InvalidFormatException;

class InstantDeserializer
extends JsonDeserializer<Instant> {
    InstantDeserializer() {
    }

    @Override
    public Instant deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        String text = p.getText();
        try {
            return Instant.from(DateTimeFormatter.ISO_INSTANT.parse(text));
        }
        catch (DateTimeException e) {
            throw new InvalidFormatException(p, "Expected an ISO 8601 formatted date time", (Object)text, Instant.class);
        }
    }
}

