/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.ext.auth.impl.hash;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import znaishaded.io.vertx.ext.auth.HashString;
import znaishaded.io.vertx.ext.auth.HashingAlgorithm;

public class SHA512
implements HashingAlgorithm {
    private static final Base64.Encoder B64ENC = Base64.getEncoder();
    private final MessageDigest md;

    public SHA512() {
        try {
            this.md = MessageDigest.getInstance("SHA-512");
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException("SHA-512 is not available", nsae);
        }
    }

    @Override
    public String id() {
        return "sha512";
    }

    @Override
    public String hash(HashString hashString, String password) {
        return B64ENC.encodeToString(this.md.digest(password.getBytes(StandardCharsets.UTF_8)));
    }
}

