/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import znaishaded.com.plantuml.api.cheerpj.WasmLog;
import znaishaded.net.sourceforge.plantuml.ErrorUml;
import znaishaded.net.sourceforge.plantuml.ErrorUmlType;
import znaishaded.net.sourceforge.plantuml.OptionFlags;
import znaishaded.net.sourceforge.plantuml.activitydiagram.ActivityDiagramFactory;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ActivityDiagramFactory3;
import znaishaded.net.sourceforge.plantuml.api.PSystemFactory;
import znaishaded.net.sourceforge.plantuml.board.BoardDiagramFactory;
import znaishaded.net.sourceforge.plantuml.bpm.BpmDiagramFactory;
import znaishaded.net.sourceforge.plantuml.classdiagram.ClassDiagramFactory;
import znaishaded.net.sourceforge.plantuml.core.Diagram;
import znaishaded.net.sourceforge.plantuml.core.DiagramType;
import znaishaded.net.sourceforge.plantuml.core.UmlSource;
import znaishaded.net.sourceforge.plantuml.dedication.PSystemDedicationFactory;
import znaishaded.net.sourceforge.plantuml.definition.PSystemDefinitionFactory;
import znaishaded.net.sourceforge.plantuml.descdiagram.DescriptionDiagramFactory;
import znaishaded.net.sourceforge.plantuml.directdot.PSystemDotFactory;
import znaishaded.net.sourceforge.plantuml.donors.PSystemDonorsFactory;
import znaishaded.net.sourceforge.plantuml.donors.PSystemSkinparameterListFactory;
import znaishaded.net.sourceforge.plantuml.ebnf.PSystemEbnfFactory;
import znaishaded.net.sourceforge.plantuml.eggs.PSystemAppleTwoFactory;
import znaishaded.net.sourceforge.plantuml.eggs.PSystemCharlieFactory;
import znaishaded.net.sourceforge.plantuml.eggs.PSystemColorsFactory;
import znaishaded.net.sourceforge.plantuml.eggs.PSystemEggFactory;
import znaishaded.net.sourceforge.plantuml.eggs.PSystemPathFactory;
import znaishaded.net.sourceforge.plantuml.eggs.PSystemRIPFactory;
import znaishaded.net.sourceforge.plantuml.eggs.PSystemUnsupported;
import znaishaded.net.sourceforge.plantuml.eggs.PSystemWelcomeFactory;
import znaishaded.net.sourceforge.plantuml.emoji.PSystemListEmojiFactory;
import znaishaded.net.sourceforge.plantuml.error.PSystemError;
import znaishaded.net.sourceforge.plantuml.error.PSystemErrorUtils;
import znaishaded.net.sourceforge.plantuml.filesdiagram.FilesDiagramFactory;
import znaishaded.net.sourceforge.plantuml.flowdiagram.FlowDiagramFactory;
import znaishaded.net.sourceforge.plantuml.font.PSystemListFontsFactory;
import znaishaded.net.sourceforge.plantuml.gitlog.GitDiagramFactory;
import znaishaded.net.sourceforge.plantuml.hcl.HclDiagramFactory;
import znaishaded.net.sourceforge.plantuml.help.HelpFactory;
import znaishaded.net.sourceforge.plantuml.jsondiagram.JsonDiagramFactory;
import znaishaded.net.sourceforge.plantuml.klimt.creole.legacy.PSystemCreoleFactory;
import znaishaded.net.sourceforge.plantuml.klimt.sprite.ListSpriteDiagramFactory;
import znaishaded.net.sourceforge.plantuml.klimt.sprite.PSystemListInternalSpritesFactory;
import znaishaded.net.sourceforge.plantuml.klimt.sprite.StdlibDiagramFactory;
import znaishaded.net.sourceforge.plantuml.math.PSystemLatexFactory;
import znaishaded.net.sourceforge.plantuml.math.PSystemMathFactory;
import znaishaded.net.sourceforge.plantuml.mindmap.MindMapDiagramFactory;
import znaishaded.net.sourceforge.plantuml.nwdiag.NwDiagramFactory;
import znaishaded.net.sourceforge.plantuml.openiconic.PSystemListOpenIconicFactory;
import znaishaded.net.sourceforge.plantuml.openiconic.PSystemOpenIconicFactory;
import znaishaded.net.sourceforge.plantuml.oregon.PSystemOregonFactory;
import znaishaded.net.sourceforge.plantuml.project.GanttDiagramFactory;
import znaishaded.net.sourceforge.plantuml.regex.RegexConcat;
import znaishaded.net.sourceforge.plantuml.regexdiagram.PSystemRegexFactory;
import znaishaded.net.sourceforge.plantuml.salt.PSystemSaltFactory;
import znaishaded.net.sourceforge.plantuml.security.SecurityProfile;
import znaishaded.net.sourceforge.plantuml.security.SecurityUtils;
import znaishaded.net.sourceforge.plantuml.sequencediagram.SequenceDiagramFactory;
import znaishaded.net.sourceforge.plantuml.statediagram.StateDiagramFactory;
import znaishaded.net.sourceforge.plantuml.stats.StatsUtilsIncrement;
import znaishaded.net.sourceforge.plantuml.text.StringLocated;
import znaishaded.net.sourceforge.plantuml.timingdiagram.TimingDiagramFactory;
import znaishaded.net.sourceforge.plantuml.utils.Log;
import znaishaded.net.sourceforge.plantuml.version.PSystemLicenseFactory;
import znaishaded.net.sourceforge.plantuml.version.PSystemVersionFactory;
import znaishaded.net.sourceforge.plantuml.wbs.WBSDiagramFactory;
import znaishaded.net.sourceforge.plantuml.wire.WireDiagramFactory;
import znaishaded.net.sourceforge.plantuml.yaml.YamlDiagramFactory;

public class PSystemBuilder {
    public static final long startTime = System.currentTimeMillis();
    private static final List<PSystemFactory> factories = new ArrayList<PSystemFactory>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Diagram createPSystem(List<StringLocated> source, List<StringLocated> rawSource, Map<String, String> skinParam) {
        WasmLog.log("..compiling diagram...");
        long now = System.currentTimeMillis();
        Object result = null;
        try {
            Object object;
            DiagramType type = DiagramType.getTypeFromArobaseStart(source.get(0).getString());
            UmlSource umlSource = UmlSource.createWithRaw(source, type == DiagramType.UML, rawSource);
            for (StringLocated stringLocated : source) {
                if (stringLocated.getPreprocessorError() == null) continue;
                assert (false);
                Log.error("Preprocessor Error: " + stringLocated.getPreprocessorError());
                ErrorUml err = new ErrorUml(ErrorUmlType.SYNTAX_ERROR, stringLocated.getPreprocessorError(), 0, stringLocated.getLocation());
                PSystemError pSystemError = PSystemErrorUtils.buildV2(umlSource, err, Collections.emptyList(), source);
                return pSystemError;
            }
            DiagramType diagramType = umlSource.getDiagramType();
            if (diagramType == DiagramType.UNKNOWN) {
                PSystemUnsupported pSystemUnsupported = new PSystemUnsupported(umlSource);
                return pSystemUnsupported;
            }
            ArrayList<PSystemError> arrayList = new ArrayList<PSystemError>();
            for (PSystemFactory systemFactory : factories) {
                if (diagramType != systemFactory.getDiagramType()) continue;
                Diagram sys = systemFactory.createSystem(umlSource, skinParam);
                if (this.isOk(sys)) {
                    result = sys;
                    Diagram diagram = sys;
                    return diagram;
                }
                arrayList.add((PSystemError)sys);
            }
            if (arrayList.size() == 0) {
                object = new PSystemUnsupported(umlSource);
                return object;
            }
            object = result = PSystemErrorUtils.merge(arrayList);
            return object;
        }
        finally {
            WasmLog.log("...parsing ok...");
            if (result != null && OptionFlags.getInstance().isEnableStats()) {
                StatsUtilsIncrement.onceMoreParse(System.currentTimeMillis() - now, result.getClass());
            }
            Log.info("Compilation duration " + (System.currentTimeMillis() - now));
            RegexConcat.printCacheInfo();
        }
    }

    private boolean isOk(Diagram ps) {
        return ps != null && !(ps instanceof PSystemError);
    }

    static {
        factories.add(new PSystemWelcomeFactory());
        factories.add(new PSystemColorsFactory());
        factories.add(new SequenceDiagramFactory());
        factories.add(new ClassDiagramFactory());
        factories.add(new ActivityDiagramFactory());
        factories.add(new DescriptionDiagramFactory());
        factories.add(new StateDiagramFactory());
        factories.add(new ActivityDiagramFactory3());
        factories.add(new BpmDiagramFactory(DiagramType.BPM));
        factories.add(new PSystemLicenseFactory());
        factories.add(new PSystemVersionFactory());
        factories.add(new PSystemDonorsFactory());
        factories.add(new PSystemSkinparameterListFactory());
        factories.add(new PSystemListFontsFactory());
        factories.add(new PSystemListEmojiFactory());
        factories.add(new PSystemOpenIconicFactory());
        factories.add(new PSystemListOpenIconicFactory());
        factories.add(new PSystemListInternalSpritesFactory());
        factories.add(new PSystemSaltFactory(DiagramType.UML));
        factories.add(new PSystemSaltFactory(DiagramType.SALT));
        factories.add(new PSystemDotFactory(DiagramType.DOT));
        factories.add(new PSystemDotFactory(DiagramType.UML));
        factories.add(new NwDiagramFactory(DiagramType.UML));
        factories.add(new NwDiagramFactory(DiagramType.NW));
        factories.add(new MindMapDiagramFactory());
        factories.add(new WBSDiagramFactory());
        factories.add(new PSystemDefinitionFactory());
        factories.add(new ListSpriteDiagramFactory());
        factories.add(new StdlibDiagramFactory());
        factories.add(new PSystemMathFactory(DiagramType.MATH));
        factories.add(new PSystemLatexFactory(DiagramType.LATEX));
        factories.add(new PSystemCreoleFactory());
        factories.add(new PSystemEggFactory());
        factories.add(new PSystemAppleTwoFactory());
        factories.add(new PSystemRIPFactory());
        if (SecurityUtils.getSecurityProfile() == SecurityProfile.UNSECURE) {
            factories.add(new PSystemPathFactory());
        }
        factories.add(new PSystemOregonFactory());
        factories.add(new PSystemCharlieFactory());
        factories.add(new GanttDiagramFactory());
        factories.add(new FlowDiagramFactory());
        factories.add(new PSystemDedicationFactory());
        factories.add(new TimingDiagramFactory());
        factories.add(new HelpFactory());
        factories.add(new WireDiagramFactory());
        factories.add(new JsonDiagramFactory());
        factories.add(new GitDiagramFactory());
        factories.add(new FilesDiagramFactory());
        factories.add(new BoardDiagramFactory());
        factories.add(new YamlDiagramFactory());
        factories.add(new HclDiagramFactory());
        factories.add(new PSystemEbnfFactory());
        factories.add(new PSystemRegexFactory());
    }
}

