/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile;

import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileDecorate;
import znaishaded.net.sourceforge.plantuml.klimt.UTranslate;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.font.StringBounder;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XDimension2D;

public class FtileMinWidthCentered
extends FtileDecorate {
    private final double minWidth;
    private FtileGeometry calculateDimensionInternal;

    public FtileMinWidthCentered(Ftile tile, double minWidth) {
        super(tile);
        this.minWidth = minWidth;
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        UTranslate change = this.getUTranslateInternal(stringBounder);
        super.drawU(ug.apply(change));
    }

    @Override
    public FtileGeometry calculateDimension(StringBounder stringBounder) {
        if (this.calculateDimensionInternal == null) {
            this.calculateDimensionInternal = this.calculateDimensionSlow(stringBounder);
        }
        return this.calculateDimensionInternal;
    }

    private FtileGeometry calculateDimensionSlow(StringBounder stringBounder) {
        FtileGeometry geo = super.calculateDimension(stringBounder);
        double left = this.getPoint2(geo.getLeft(), stringBounder);
        if (!geo.hasPointOut()) {
            return new FtileGeometry(this.getDimensionInternal(stringBounder), left, geo.getInY());
        }
        return new FtileGeometry(this.getDimensionInternal(stringBounder), left, geo.getInY(), geo.getOutY());
    }

    private XDimension2D getDimensionInternal(StringBounder stringBounder) {
        FtileGeometry dim = this.getFtileDelegated().calculateDimension(stringBounder);
        if (((XDimension2D)dim).getWidth() < this.minWidth) {
            return new XDimension2D(this.minWidth, ((XDimension2D)dim).getHeight());
        }
        return dim;
    }

    private UTranslate getUTranslateInternal(StringBounder stringBounder) {
        FtileGeometry dimTile = this.getFtileDelegated().calculateDimension(stringBounder);
        XDimension2D dimTotal = this.getDimensionInternal(stringBounder);
        UTranslate change = UTranslate.dx((dimTotal.getWidth() - ((XDimension2D)dimTile).getWidth()) / 2.0);
        return change;
    }

    @Override
    public UTranslate getTranslateFor(Ftile child, StringBounder stringBounder) {
        if (child == this.getFtileDelegated()) {
            return this.getUTranslateInternal(stringBounder);
        }
        return null;
    }

    private double getPoint2(double x, StringBounder stringBounder) {
        FtileGeometry dim = this.getFtileDelegated().calculateDimension(stringBounder);
        if (((XDimension2D)dim).getWidth() < this.minWidth) {
            double diff = this.minWidth - ((XDimension2D)dim).getWidth();
            return x + diff / 2.0;
        }
        return x;
    }
}

