/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.decoration.symbol;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import znaishaded.net.sourceforge.plantuml.decoration.symbol.USymbol;
import znaishaded.net.sourceforge.plantuml.klimt.Fashion;
import znaishaded.net.sourceforge.plantuml.klimt.UPath;
import znaishaded.net.sourceforge.plantuml.klimt.UTranslate;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphicStencil;
import znaishaded.net.sourceforge.plantuml.klimt.font.StringBounder;
import znaishaded.net.sourceforge.plantuml.klimt.geom.CoordinateChange;
import znaishaded.net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XDimension2D;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XPoint2D;
import znaishaded.net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import znaishaded.net.sourceforge.plantuml.klimt.shape.TextBlock;
import znaishaded.net.sourceforge.plantuml.klimt.shape.TextBlockUtils;
import znaishaded.net.sourceforge.plantuml.style.SName;

class USymbolCloud
extends USymbol {
    private static final boolean NEW = true;
    private static final boolean DEBUG = false;

    USymbolCloud() {
    }

    @Override
    public SName getSName() {
        return SName.cloud;
    }

    private void drawCloud(UGraphic ug, double width, double height, double shadowing) {
        UPath shape = this.getSpecificFrontierForCloud(width, height);
        shape.setDeltaShadow(shadowing);
        ug.apply(UTranslate.dy(0.0)).draw(shape);
    }

    private UPath getSpecificFrontierForCloudNew(double width, double height) {
        Random rnd = new Random((long)width + 7919L * (long)height);
        ArrayList<XPoint2D> points = new ArrayList<XPoint2D>();
        double bubbleSize = 11.0;
        if (Math.max(width, height) / bubbleSize > 16.0) {
            bubbleSize = Math.max(width, height) / 16.0;
        }
        double margin1 = 8.0;
        XPoint2D pointA = new XPoint2D(8.0, 8.0);
        XPoint2D pointB = new XPoint2D(width - 8.0, 8.0);
        XPoint2D pointC = new XPoint2D(width - 8.0, height - 8.0);
        XPoint2D pointD = new XPoint2D(8.0, height - 8.0);
        if (width > 100.0 && height > 100.0) {
            this.complex(rnd, points, bubbleSize, pointA, pointB, pointC, pointD);
        } else {
            this.simple(rnd, points, bubbleSize, pointA, pointB, pointC, pointD);
        }
        points.add((XPoint2D)points.get(0));
        UPath result = UPath.none();
        result.moveTo((XPoint2D)points.get(0));
        for (int i = 0; i < points.size() - 1; ++i) {
            this.addCurve(rnd, result, (XPoint2D)points.get(i), (XPoint2D)points.get(i + 1));
        }
        return result;
    }

    private void complex(Random rnd, List<XPoint2D> points, double bubbleSize, XPoint2D pointA, XPoint2D pointB, XPoint2D pointC, XPoint2D pointD) {
        double margin2 = 7.0;
        this.specialLine(bubbleSize, rnd, points, USymbolCloud.mvX(pointA, 7.0), USymbolCloud.mvX(pointB, -7.0));
        points.add(USymbolCloud.mvY(pointB, 7.0));
        this.specialLine(bubbleSize, rnd, points, USymbolCloud.mvY(pointB, 7.0), USymbolCloud.mvY(pointC, -7.0));
        points.add(USymbolCloud.mvX(pointC, -7.0));
        this.specialLine(bubbleSize, rnd, points, USymbolCloud.mvX(pointC, -7.0), USymbolCloud.mvX(pointD, 7.0));
        points.add(USymbolCloud.mvY(pointD, -7.0));
        this.specialLine(bubbleSize, rnd, points, USymbolCloud.mvY(pointD, -7.0), USymbolCloud.mvY(pointA, 7.0));
        points.add(USymbolCloud.mvX(pointA, 7.0));
    }

    private void simple(Random rnd, List<XPoint2D> points, double bubbleSize, XPoint2D pointA, XPoint2D pointB, XPoint2D pointC, XPoint2D pointD) {
        this.specialLine(bubbleSize, rnd, points, pointA, pointB);
        this.specialLine(bubbleSize, rnd, points, pointB, pointC);
        this.specialLine(bubbleSize, rnd, points, pointC, pointD);
        this.specialLine(bubbleSize, rnd, points, pointD, pointA);
    }

    private static XPoint2D mvX(XPoint2D pt, double dx) {
        return new XPoint2D(pt.getX() + dx, pt.getY());
    }

    private static XPoint2D mvY(XPoint2D pt, double dy) {
        return new XPoint2D(pt.getX(), pt.getY() + dy);
    }

    private void specialLine(double bubbleSize, Random rnd, List<XPoint2D> points, XPoint2D p1, XPoint2D p2) {
        CoordinateChange change = CoordinateChange.create(p1, p2);
        double length = change.getLength();
        XPoint2D middle = change.getTrueCoordinate(length / 2.0, -USymbolCloud.rnd(rnd, 1.0, 1.0 + Math.min(12.0, bubbleSize * 0.8)));
        this.bubbleLine(rnd, points, p1, middle, bubbleSize);
        this.bubbleLine(rnd, points, middle, p2, bubbleSize);
    }

    private void bubbleLine(Random rnd, List<XPoint2D> points, XPoint2D p1, XPoint2D p2, double bubbleSize) {
        CoordinateChange change = CoordinateChange.create(p1, p2);
        double length = change.getLength();
        int nb = (int)(length / bubbleSize);
        if (nb == 0) {
            bubbleSize = length / 2.0;
            nb = (int)(length / bubbleSize);
        }
        for (int i = 0; i < nb; ++i) {
            points.add(USymbolCloud.rnd(rnd, change.getTrueCoordinate((double)i * length / (double)nb, 0.0), bubbleSize * 0.2));
        }
    }

    private void addCurve(Random rnd, UPath path, XPoint2D p1, XPoint2D p2) {
        CoordinateChange change = CoordinateChange.create(p1, p2);
        double length = change.getLength();
        double coef = USymbolCloud.rnd(rnd, 0.25, 0.35);
        XPoint2D middle = change.getTrueCoordinate(length * coef, -length * USymbolCloud.rnd(rnd, 0.4, 0.55));
        XPoint2D middle2 = change.getTrueCoordinate(length * (1.0 - coef), -length * USymbolCloud.rnd(rnd, 0.4, 0.55));
        path.cubicTo(middle, middle2, p2);
    }

    private static double rnd(Random rnd, double a, double b) {
        return rnd.nextDouble() * (b - a) + a;
    }

    private static XPoint2D rnd(Random rnd, XPoint2D pt, double v) {
        double x = pt.getX() + v * rnd.nextDouble();
        double y = pt.getY() + v * rnd.nextDouble();
        return new XPoint2D(x, y);
    }

    private UPath getSpecificFrontierForCloud(double width, double height) {
        return this.getSpecificFrontierForCloudNew(width, height);
    }

    private USymbol.Margin getMargin() {
        return new USymbol.Margin(15.0, 15.0, 15.0, 15.0);
    }

    @Override
    public TextBlock asSmall(TextBlock name, final TextBlock label, final TextBlock stereotype, final Fashion symbolContext, HorizontalAlignment stereoAlignment) {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                XDimension2D dim = this.calculateDimension(ug.getStringBounder());
                ug = UGraphicStencil.create(ug, dim);
                ug = symbolContext.apply(ug);
                USymbolCloud.this.drawCloud(ug, dim.getWidth(), dim.getHeight(), symbolContext.getDeltaShadow());
                USymbol.Margin margin = USymbolCloud.this.getMargin();
                TextBlock tb = TextBlockUtils.mergeTB(stereotype, label, HorizontalAlignment.CENTER);
                tb.drawU(ug.apply(new UTranslate(margin.getX1(), margin.getY1())));
            }

            @Override
            public XDimension2D calculateDimension(StringBounder stringBounder) {
                XDimension2D dimLabel = label.calculateDimension(stringBounder);
                XDimension2D dimStereo = stereotype.calculateDimension(stringBounder);
                return USymbolCloud.this.getMargin().addDimension(dimStereo.mergeTB(dimLabel));
            }
        };
    }

    @Override
    public TextBlock asBig(final TextBlock title, HorizontalAlignment labelAlignment, final TextBlock stereotype, final double width, final double height, final Fashion symbolContext, HorizontalAlignment stereoAlignment) {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                XDimension2D dim = this.calculateDimension(ug.getStringBounder());
                ug = symbolContext.apply(ug);
                USymbolCloud.this.drawCloud(ug, dim.getWidth(), dim.getHeight(), symbolContext.getDeltaShadow());
                XDimension2D dimStereo = stereotype.calculateDimension(ug.getStringBounder());
                double posStereo = (width - dimStereo.getWidth()) / 2.0;
                stereotype.drawU(ug.apply(new UTranslate(posStereo, 13.0)));
                XDimension2D dimTitle = title.calculateDimension(ug.getStringBounder());
                double posTitle = (width - dimTitle.getWidth()) / 2.0;
                title.drawU(ug.apply(new UTranslate(posTitle, 13.0 + dimStereo.getHeight())));
            }

            @Override
            public XDimension2D calculateDimension(StringBounder stringBounder) {
                return new XDimension2D(width, height);
            }
        };
    }
}

