/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.dedication;

import java.math.BigInteger;

public class RBlock {
    private final byte[] buffer;

    private RBlock(byte[] init) {
        this.buffer = new byte[init.length + 1];
        System.arraycopy(init, 0, this.buffer, 1, init.length);
    }

    public RBlock(byte[] init, int start, int size) {
        this.buffer = new byte[size + 1];
        if (start + size < init.length) {
            System.arraycopy(init, start, this.buffer, 1, size);
        } else {
            System.arraycopy(init, start, this.buffer, 1, init.length - start);
        }
    }

    public RBlock change(BigInteger E, BigInteger N) {
        BigInteger big = new BigInteger(this.buffer);
        BigInteger changed = big.modPow(E, N);
        return new RBlock(changed.toByteArray());
    }

    public byte[] getData(int size) {
        if (this.buffer.length == size) {
            return this.buffer;
        }
        byte[] result = new byte[size];
        System.arraycopy(this.buffer, this.buffer.length - size, result, 0, size);
        return result;
    }
}

