/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.klimt.creole.command;

import java.awt.image.BufferedImage;
import java.io.IOException;
import znaishaded.net.sourceforge.plantuml.FileSystem;
import znaishaded.net.sourceforge.plantuml.FileUtils;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.klimt.creole.command.HtmlCommand;
import znaishaded.net.sourceforge.plantuml.klimt.creole.command.PlainText;
import znaishaded.net.sourceforge.plantuml.klimt.geom.ImgValign;
import znaishaded.net.sourceforge.plantuml.klimt.shape.TextBlock;
import znaishaded.net.sourceforge.plantuml.klimt.shape.TileImage;
import znaishaded.net.sourceforge.plantuml.klimt.shape.TileImageSvg;
import znaishaded.net.sourceforge.plantuml.log.Logme;
import znaishaded.net.sourceforge.plantuml.regex.Matcher2;
import znaishaded.net.sourceforge.plantuml.regex.MyPattern;
import znaishaded.net.sourceforge.plantuml.regex.Pattern2;
import znaishaded.net.sourceforge.plantuml.security.SFile;
import znaishaded.net.sourceforge.plantuml.security.SURL;

public class Img
implements HtmlCommand {
    private static final Pattern2 srcPattern = MyPattern.cmpile("src[%s]*=[%s]*[\"%q]?([^%s\">]+)[\"%q]?");
    private static final Pattern2 vspacePattern = MyPattern.cmpile("vspace[%s]*=[%s]*[\"%q]?(\\d+)[\"%q]?");
    private static final Pattern2 valignPattern = MyPattern.cmpile("valign[%s]*=[%s]*[\"%q]?(top|bottom|middle)[\"%q]?");
    private static final Pattern2 noSrcColonPattern = MyPattern.cmpile("\\<img[\\s:]+([^>{}]+)(\\{scale=(?:[0-9.]+)\\})?\\>");
    private final TextBlock tileImage;

    private Img(TextBlock image) {
        this.tileImage = image;
    }

    static int getVspace(String html) {
        Matcher2 m3 = vspacePattern.matcher(html);
        if (!m3.find()) {
            return 0;
        }
        return Integer.parseInt(m3.group(1));
    }

    static ImgValign getValign(String html) {
        Matcher2 m3 = valignPattern.matcher(html);
        if (!m3.find()) {
            return ImgValign.TOP;
        }
        return ImgValign.valueOf(StringUtils.goUpperCase(m3.group(1)));
    }

    static HtmlCommand getInstance(String html, boolean withSrc) {
        if (withSrc) {
            Matcher2 m3 = srcPattern.matcher(html);
            int vspace = Img.getVspace(html);
            ImgValign valign = Img.getValign(html);
            return Img.build(m3, valign, vspace);
        }
        Matcher2 m4 = noSrcColonPattern.matcher(html);
        return Img.build(m4, ImgValign.TOP, 0);
    }

    private static HtmlCommand build(Matcher2 m3, ImgValign valign, int vspace) {
        if (!m3.find()) {
            return new PlainText("(SYNTAX ERROR)");
        }
        String src = m3.group(1);
        try {
            SFile f = FileSystem.getInstance().getFile(src);
            if (!f.exists()) {
                if (src.startsWith("http:") || src.startsWith("https:")) {
                    SURL tmp = SURL.create(src);
                    if (tmp == null) {
                        return new PlainText("(Cannot decode: " + src + ")");
                    }
                    BufferedImage read = tmp.readRasterImageFromURL();
                    if (read == null) {
                        return new PlainText("(Cannot decode: " + src + ")");
                    }
                    return new Img(new TileImage(read, valign, vspace));
                }
                return new PlainText("(Cannot decode: " + f + ")");
            }
            if (f.getName().endsWith(".svg")) {
                String tmp = FileUtils.readSvg(f);
                if (tmp == null) {
                    return new PlainText("(Cannot decode: " + f + ")");
                }
                return new Img(new TileImageSvg(tmp, 1.0));
            }
            BufferedImage read = f.readRasterImageFromFile();
            if (read == null) {
                return new PlainText("(Cannot decode: " + f + ")");
            }
            return new Img(new TileImage(f.readRasterImageFromFile(), valign, vspace));
        }
        catch (IOException e) {
            Logme.error(e);
            return new PlainText("ERROR " + e.toString());
        }
    }

    public TextBlock createMonoImage() {
        return this.tileImage;
    }
}

