/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.klimt.creole.legacy;

import java.util.Collections;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.klimt.creole.Neutron;
import znaishaded.net.sourceforge.plantuml.klimt.creole.Parser;
import znaishaded.net.sourceforge.plantuml.klimt.creole.atom.Atom;
import znaishaded.net.sourceforge.plantuml.klimt.creole.atom.AtomMath;
import znaishaded.net.sourceforge.plantuml.klimt.creole.legacy.StripeRaw;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.font.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.klimt.font.StringBounder;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XDimension2D;
import znaishaded.net.sourceforge.plantuml.math.ScientificEquationSafe;

public class StripeLatex
implements StripeRaw {
    private final FontConfiguration fontConfiguration;
    private final StringBuilder formula = new StringBuilder();
    private AtomMath atom;
    private boolean terminated;

    public StripeLatex(FontConfiguration fontConfiguration) {
        this.fontConfiguration = fontConfiguration;
    }

    @Override
    public List<Atom> getAtoms() {
        return Collections.singletonList(this);
    }

    @Override
    public Atom getLHeader() {
        return null;
    }

    @Override
    public boolean addAndCheckTermination(String line) {
        if (Parser.isLatexEnd(line)) {
            this.terminated = true;
            return true;
        }
        this.formula.append(line);
        return false;
    }

    @Override
    public final boolean isTerminated() {
        return this.terminated;
    }

    private Atom getAtom() {
        if (this.atom == null) {
            ScientificEquationSafe math = ScientificEquationSafe.fromLatex(this.formula.toString());
            this.atom = new AtomMath(math, this.fontConfiguration.getColor(), this.fontConfiguration.getExtendedColor());
        }
        return this.atom;
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        return this.getAtom().calculateDimension(stringBounder);
    }

    @Override
    public double getStartingAltitude(StringBounder stringBounder) {
        return 0.0;
    }

    @Override
    public void drawU(UGraphic ug) {
        this.getAtom().drawU(ug);
    }

    @Override
    public List<Neutron> getNeutrons() {
        throw new UnsupportedOperationException();
    }
}

