/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.klimt.drawing.tikz;

import java.io.IOException;
import java.io.OutputStream;
import znaishaded.net.sourceforge.plantuml.klimt.ClipContainer;
import znaishaded.net.sourceforge.plantuml.klimt.UPath;
import znaishaded.net.sourceforge.plantuml.klimt.color.ColorMapper;
import znaishaded.net.sourceforge.plantuml.klimt.color.HColor;
import znaishaded.net.sourceforge.plantuml.klimt.creole.legacy.AtomText;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.AbstractCommonUGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.AbstractUGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.tikz.DriverAtomTextTikz;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.tikz.DriverCenteredCharacterTikz2;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.tikz.DriverDotPathTikz;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.tikz.DriverEllipseTikz;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.tikz.DriverImageTikz;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.tikz.DriverLineTikz;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.tikz.DriverPathTikz;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.tikz.DriverPolygonTikz;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.tikz.DriverRectangleTikz;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.tikz.DriverTextTikz;
import znaishaded.net.sourceforge.plantuml.klimt.font.StringBounder;
import znaishaded.net.sourceforge.plantuml.klimt.shape.DotPath;
import znaishaded.net.sourceforge.plantuml.klimt.shape.UCenteredCharacter;
import znaishaded.net.sourceforge.plantuml.klimt.shape.UEllipse;
import znaishaded.net.sourceforge.plantuml.klimt.shape.UImage;
import znaishaded.net.sourceforge.plantuml.klimt.shape.UImageSvg;
import znaishaded.net.sourceforge.plantuml.klimt.shape.ULine;
import znaishaded.net.sourceforge.plantuml.klimt.shape.UPolygon;
import znaishaded.net.sourceforge.plantuml.klimt.shape.URectangle;
import znaishaded.net.sourceforge.plantuml.klimt.shape.UText;
import znaishaded.net.sourceforge.plantuml.tikz.TikzGraphics;
import znaishaded.net.sourceforge.plantuml.url.Url;

public class UGraphicTikz
extends AbstractUGraphic<TikzGraphics>
implements ClipContainer {
    public UGraphicTikz(HColor defaultBackground, ColorMapper colorMapper, StringBounder stringBounder, double scale, boolean withPreamble) {
        super(stringBounder);
        this.copy(defaultBackground, colorMapper, new TikzGraphics(scale, withPreamble, colorMapper));
        this.register();
    }

    @Override
    protected AbstractCommonUGraphic copyUGraphic() {
        UGraphicTikz result = new UGraphicTikz(this);
        return result;
    }

    private UGraphicTikz(UGraphicTikz other) {
        super(other.getStringBounder());
        this.copy(other);
        this.register();
    }

    private void register() {
        this.registerDriver(URectangle.class, new DriverRectangleTikz());
        this.registerDriver(UText.class, new DriverTextTikz());
        this.registerDriver(AtomText.class, new DriverAtomTextTikz());
        this.registerDriver(ULine.class, new DriverLineTikz());
        this.registerDriver(UPolygon.class, new DriverPolygonTikz());
        this.registerDriver(UEllipse.class, new DriverEllipseTikz());
        this.registerDriver(UImage.class, new DriverImageTikz());
        this.ignoreShape(UImageSvg.class);
        this.registerDriver(UPath.class, new DriverPathTikz());
        this.registerDriver(DotPath.class, new DriverDotPathTikz());
        this.registerDriver(UCenteredCharacter.class, new DriverCenteredCharacterTikz2());
    }

    @Override
    public void startUrl(Url url) {
        ((TikzGraphics)this.getGraphicObject()).openLink(url.getUrl(), url.getTooltip());
    }

    @Override
    public void closeUrl() {
        ((TikzGraphics)this.getGraphicObject()).closeLink();
    }

    @Override
    public void writeToStream(OutputStream os, String metadata, int dpi) throws IOException {
        ((TikzGraphics)this.getGraphicObject()).createData(os);
    }

    @Override
    public boolean matchesProperty(String propertyName) {
        return "SPECIALTXT".equalsIgnoreCase(propertyName);
    }
}

