/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.klimt.shape;

import java.util.ArrayList;
import java.util.List;
import znaishaded.net.atmp.InnerStrategy;
import znaishaded.net.sourceforge.plantuml.klimt.UTranslate;
import znaishaded.net.sourceforge.plantuml.klimt.color.HColor;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.font.StringBounder;
import znaishaded.net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XDimension2D;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XRectangle2D;
import znaishaded.net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import znaishaded.net.sourceforge.plantuml.klimt.shape.TextBlock;
import znaishaded.net.sourceforge.plantuml.klimt.shape.UImage;
import znaishaded.net.sourceforge.plantuml.klimt.shape.URectangle;
import znaishaded.net.sourceforge.plantuml.svek.Ports;
import znaishaded.net.sourceforge.plantuml.svek.WithPorts;

public class TextBlockVertical2
extends AbstractTextBlock
implements TextBlock,
WithPorts {
    private final List<TextBlock> blocks = new ArrayList<TextBlock>();
    private final HorizontalAlignment horizontalAlignment;

    TextBlockVertical2(TextBlock b1, TextBlock b2, HorizontalAlignment horizontalAlignment) {
        this.blocks.add(b1);
        this.blocks.add(b2);
        this.horizontalAlignment = horizontalAlignment;
    }

    TextBlockVertical2(TextBlock b1, UImage image, HorizontalAlignment horizontalAlignment) {
        this(b1, TextBlockVertical2.convertImage(image), horizontalAlignment);
    }

    private static AbstractTextBlock convertImage(final UImage image) {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                ug.draw(image);
            }

            @Override
            public XDimension2D calculateDimension(StringBounder stringBounder) {
                return new XDimension2D(image.getWidth(), image.getHeight());
            }
        };
    }

    public TextBlockVertical2(List<TextBlock> all, HorizontalAlignment horizontalAlignment) {
        if (all.size() < 2) {
            throw new IllegalArgumentException();
        }
        this.blocks.addAll(all);
        this.horizontalAlignment = horizontalAlignment;
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        XDimension2D dim = this.blocks.get(0).calculateDimension(stringBounder);
        for (int i = 1; i < this.blocks.size(); ++i) {
            dim = dim.mergeTB(this.blocks.get(i).calculateDimension(stringBounder));
        }
        return dim;
    }

    @Override
    public void drawU(UGraphic ug) {
        double y = 0.0;
        XDimension2D dimtotal = this.calculateDimension(ug.getStringBounder());
        for (TextBlock block : this.blocks) {
            double dx;
            XDimension2D dimb = block.calculateDimension(ug.getStringBounder());
            HColor back = block.getBackcolor();
            if (back != null && !back.isTransparent()) {
                ug.apply(UTranslate.dy(y)).apply(back).apply(back.bg()).draw(URectangle.build(dimtotal.getWidth(), dimb.getHeight()));
            }
            if (this.horizontalAlignment == HorizontalAlignment.LEFT) {
                block.drawU(ug.apply(UTranslate.dy(y)));
            } else if (this.horizontalAlignment == HorizontalAlignment.CENTER) {
                dx = (dimtotal.getWidth() - dimb.getWidth()) / 2.0;
                block.drawU(ug.apply(new UTranslate(dx, y)));
            } else if (this.horizontalAlignment == HorizontalAlignment.RIGHT) {
                dx = dimtotal.getWidth() - dimb.getWidth();
                block.drawU(ug.apply(new UTranslate(dx, y)));
            } else {
                throw new UnsupportedOperationException();
            }
            y += dimb.getHeight();
        }
    }

    @Override
    public Ports getPorts(StringBounder stringBounder) {
        double y = 0.0;
        Ports result = new Ports();
        for (TextBlock block : this.blocks) {
            XDimension2D dimb = block.calculateDimension(stringBounder);
            Ports tmp = ((WithPorts)((Object)block)).getPorts(stringBounder).translateY(y);
            result.addThis(tmp);
            y += dimb.getHeight();
        }
        return result;
    }

    @Override
    public XRectangle2D getInnerPosition(String member, StringBounder stringBounder, InnerStrategy strategy) {
        double y = 0.0;
        for (TextBlock block : this.blocks) {
            XDimension2D dimb = block.calculateDimension(stringBounder);
            XRectangle2D result = block.getInnerPosition(member, stringBounder, strategy);
            if (result != null) {
                return UTranslate.dy(y).apply(result);
            }
            y += dimb.getHeight();
        }
        return null;
    }
}

