/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.klimt.sprite;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import znaishaded.net.atmp.ImageBuilder;
import znaishaded.net.sourceforge.plantuml.FileFormatOption;
import znaishaded.net.sourceforge.plantuml.UmlDiagram;
import znaishaded.net.sourceforge.plantuml.core.DiagramDescription;
import znaishaded.net.sourceforge.plantuml.core.ImageData;
import znaishaded.net.sourceforge.plantuml.core.UmlSource;
import znaishaded.net.sourceforge.plantuml.klimt.UTranslate;
import znaishaded.net.sourceforge.plantuml.klimt.color.HColors;
import znaishaded.net.sourceforge.plantuml.klimt.creole.Display;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.font.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.klimt.font.StringBounder;
import znaishaded.net.sourceforge.plantuml.klimt.font.UFont;
import znaishaded.net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XDimension2D;
import znaishaded.net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import znaishaded.net.sourceforge.plantuml.klimt.shape.TextBlock;
import znaishaded.net.sourceforge.plantuml.klimt.shape.TextBlockUtils;
import znaishaded.net.sourceforge.plantuml.klimt.sprite.Sprite;
import znaishaded.net.sourceforge.plantuml.skin.UmlDiagramType;

public class ListSpriteDiagram
extends UmlDiagram {
    public ListSpriteDiagram(UmlSource source, Map<String, String> skinParam) {
        super(source, UmlDiagramType.HELP, skinParam);
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(Sprites)");
    }

    @Override
    public ImageBuilder createImageBuilder(FileFormatOption fileFormatOption) throws IOException {
        return super.createImageBuilder(fileFormatOption).annotations(false);
    }

    @Override
    protected ImageData exportDiagramInternal(OutputStream os, int index, FileFormatOption fileFormatOption) throws IOException {
        return this.createImageBuilder(fileFormatOption).drawable(this.getTextBlock()).write(os);
    }

    @Override
    protected TextBlock getTextBlock() {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                double x = 0.0;
                double y = 0.0;
                double rawHeight = 0.0;
                for (String n : ListSpriteDiagram.this.getSkinParam().getAllSpriteNames()) {
                    Sprite sprite = ListSpriteDiagram.this.getSkinParam().getSprite(n);
                    TextBlock blockName = Display.create(n).create(FontConfiguration.blackBlueTrue(UFont.sansSerif(14)), HorizontalAlignment.LEFT, ListSpriteDiagram.this.getSkinParam());
                    TextBlock tb = sprite.asTextBlock(HColors.BLACK, 1.0);
                    tb = TextBlockUtils.mergeTB(tb, blockName, HorizontalAlignment.CENTER);
                    tb.drawU(ug.apply(new UTranslate(x, y)));
                    XDimension2D dim = tb.calculateDimension(ug.getStringBounder());
                    rawHeight = Math.max(rawHeight, dim.getHeight());
                    x += dim.getWidth();
                    if (!((x += 30.0) > 1024.0)) continue;
                    x = 0.0;
                    y += rawHeight + 50.0;
                    rawHeight = 0.0;
                }
            }

            @Override
            public XDimension2D calculateDimension(StringBounder stringBounder) {
                return new XDimension2D(1024.0, 1024.0);
            }
        };
    }
}

