/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.objectdiagram.command;

import znaishaded.net.sourceforge.plantuml.abel.Entity;
import znaishaded.net.sourceforge.plantuml.abel.LeafType;
import znaishaded.net.sourceforge.plantuml.classdiagram.AbstractEntityDiagram;
import znaishaded.net.sourceforge.plantuml.command.CommandControl;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.command.CommandMultilines2;
import znaishaded.net.sourceforge.plantuml.command.MultilinesStrategy;
import znaishaded.net.sourceforge.plantuml.command.Trim;
import znaishaded.net.sourceforge.plantuml.cucadiagram.BodierJSon;
import znaishaded.net.sourceforge.plantuml.json.Json;
import znaishaded.net.sourceforge.plantuml.json.JsonParser;
import znaishaded.net.sourceforge.plantuml.json.JsonValue;
import znaishaded.net.sourceforge.plantuml.klimt.color.ColorParser;
import znaishaded.net.sourceforge.plantuml.klimt.color.ColorType;
import znaishaded.net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import znaishaded.net.sourceforge.plantuml.klimt.creole.CreoleMode;
import znaishaded.net.sourceforge.plantuml.klimt.creole.Display;
import znaishaded.net.sourceforge.plantuml.klimt.font.FontParam;
import znaishaded.net.sourceforge.plantuml.plasma.Quark;
import znaishaded.net.sourceforge.plantuml.regex.IRegex;
import znaishaded.net.sourceforge.plantuml.regex.RegexConcat;
import znaishaded.net.sourceforge.plantuml.regex.RegexLeaf;
import znaishaded.net.sourceforge.plantuml.regex.RegexResult;
import znaishaded.net.sourceforge.plantuml.stereo.Stereotype;
import znaishaded.net.sourceforge.plantuml.text.StringLocated;
import znaishaded.net.sourceforge.plantuml.url.UrlBuilder;
import znaishaded.net.sourceforge.plantuml.utils.BlocLines;

public class CommandCreateJson
extends CommandMultilines2<AbstractEntityDiagram> {
    public CommandCreateJson() {
        super(CommandCreateJson.getRegexConcat(), MultilinesStrategy.REMOVE_STARTING_QUOTE, Trim.BOTH);
    }

    private static IRegex getRegexConcat() {
        return RegexConcat.build(CommandCreateJson.class.getName(), RegexLeaf.start(), new RegexLeaf("TYPE", "json"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("NAME", "(?:[%g]([^%g]+)[%g][%s]+as[%s]+)?([%pLN_.]+)"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("STEREO", "(\\<\\<.+\\>\\>)?"), RegexLeaf.spaceZeroOrMore(), UrlBuilder.OPTIONAL, RegexLeaf.spaceZeroOrMore(), ColorParser.exp1(), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("\\{"), RegexLeaf.end());
    }

    @Override
    public String getPatternEnd() {
        return "^[%s]*\\}[%s]*$";
    }

    @Override
    protected CommandExecutionResult executeNow(AbstractEntityDiagram diagram, BlocLines lines) throws NoSuchColorException {
        lines = lines.trim().removeEmptyLines();
        RegexResult line0 = this.getStartingPattern().matcher(lines.getFirst().getTrimmed().getString());
        Entity entity1 = this.executeArg0(diagram, line0);
        if (entity1 == null) {
            return CommandExecutionResult.error("No such entity");
        }
        JsonValue json = this.getJsonValue(lines);
        if (json == null) {
            return CommandExecutionResult.error("Bad data");
        }
        ((BodierJSon)entity1.getBodier()).setJson(json);
        return CommandExecutionResult.ok();
    }

    @Override
    protected CommandControl finalVerification(BlocLines lines) {
        JsonValue json = this.getJsonValue(lines);
        if (json == null) {
            return CommandControl.OK_PARTIAL;
        }
        return super.finalVerification(lines);
    }

    private JsonValue getJsonValue(BlocLines lines) {
        try {
            String sb = this.getJsonString(lines);
            Json.DefaultHandler handler = new Json.DefaultHandler();
            new JsonParser(handler).parse(sb);
            JsonValue json = handler.getValue();
            return json;
        }
        catch (Exception e) {
            return null;
        }
    }

    private String getJsonString(BlocLines lines) {
        lines = lines.subExtract(1, 1);
        StringBuilder sb = new StringBuilder("{");
        for (StringLocated sl : lines) {
            String line = sl.getString();
            assert (line.length() > 0);
            sb.append(line);
        }
        sb.append("}");
        return sb.toString();
    }

    private Entity executeArg0(AbstractEntityDiagram diagram, RegexResult line0) throws NoSuchColorException {
        String s2;
        String name = line0.get("NAME", 1);
        Quark<Entity> quark = diagram.quarkInContext(true, diagram.cleanId(name));
        if (quark.getData() != null) {
            return null;
        }
        String displayString = line0.get("NAME", 0);
        String stereotype = line0.get("STEREO", 0);
        Display display = Display.getWithNewlines(displayString);
        if (Display.isNull(display)) {
            display = Display.getWithNewlines(name).withCreoleMode(CreoleMode.SIMPLE_LINE);
        }
        Entity entity = diagram.reallyCreateLeaf(quark, display, LeafType.JSON, null);
        if (stereotype != null) {
            entity.setStereotype(Stereotype.build(stereotype, diagram.getSkinParam().getCircledCharacterRadius(), diagram.getSkinParam().getFont(null, false, FontParam.CIRCLED_CHARACTER), diagram.getSkinParam().getIHtmlColorSet()));
        }
        entity.setSpecificColorTOBEREMOVED(ColorType.BACK, (s2 = line0.get("COLOR", 0)) == null ? null : diagram.getSkinParam().getIHtmlColorSet().getColor(s2));
        return entity;
    }
}

