/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.project.core3;

import java.util.Map;
import java.util.TreeMap;
import znaishaded.net.sourceforge.plantuml.project.core3.Histogram;
import znaishaded.net.sourceforge.plantuml.project.core3.TimeLine;

public class HistogramSimple
implements Histogram {
    private final Map<Long, Long> events = new TreeMap<Long, Long>();

    @Override
    public long getNext(long moment) {
        for (long e : this.events.keySet()) {
            if (e <= moment) continue;
            return e;
        }
        return TimeLine.MAX_TIME;
    }

    @Override
    public long getPrevious(long moment) {
        long last = -TimeLine.MAX_TIME.longValue();
        for (long e : this.events.keySet()) {
            if (e >= moment) {
                return last;
            }
            last = e;
        }
        return last;
    }

    public void put(long event, long value) {
        this.events.put(event, value);
    }

    public String toString() {
        return this.events.toString();
    }

    @Override
    public long getValueAt(long moment) {
        long last = 0L;
        for (Map.Entry<Long, Long> ent : this.events.entrySet()) {
            if (ent.getKey() > moment) {
                return last;
            }
            last = ent.getValue();
        }
        return last;
    }
}

