/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.salt.element;

import znaishaded.net.sourceforge.plantuml.klimt.UStroke;
import znaishaded.net.sourceforge.plantuml.klimt.UTranslate;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.font.StringBounder;
import znaishaded.net.sourceforge.plantuml.klimt.font.UFont;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XDimension2D;
import znaishaded.net.sourceforge.plantuml.klimt.shape.URectangle;
import znaishaded.net.sourceforge.plantuml.salt.element.AbstractElementText;
import znaishaded.net.sourceforge.plantuml.salt.element.Element;
import znaishaded.net.sourceforge.plantuml.style.ISkinSimple;

public class ElementButton
extends AbstractElementText
implements Element {
    private final double stroke = 2.5;
    private final double marginX = 2.0;
    private final double marginY = 2.0;

    public ElementButton(String text, UFont font, ISkinSimple spriteContainer) {
        super(text, font, true, spriteContainer);
    }

    @Override
    public XDimension2D getPreferredDimension(StringBounder stringBounder, double x, double y) {
        XDimension2D dim = this.getTextDimensionAt(stringBounder, x + 2.5 + 2.0);
        dim = dim.delta(4.0, 4.0);
        return dim.delta(5.0);
    }

    @Override
    public void drawU(UGraphic ug, int zIndex, XDimension2D dimToUse) {
        if (zIndex != 0) {
            return;
        }
        XDimension2D dim = this.getPreferredDimension(ug.getStringBounder(), 0.0, 0.0);
        ug = ug.apply(UStroke.withThickness(2.5));
        ug = ug.apply(this.getColorEE().bg()).apply(this.getBlack());
        ug.apply(new UTranslate(2.5, 2.5)).draw(URectangle.build(dim.getWidth() - 5.0, dim.getHeight() - 5.0).rounded(10.0));
        XDimension2D dimPureText = this.getPureTextDimension(ug.getStringBounder());
        this.drawText(ug, (dim.getWidth() - dimPureText.getWidth()) / 2.0, 4.5);
    }
}

