/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.apache.ant.compress.resources;

import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import znaishaded.org.apache.ant.compress.resources.CommonsCompressArchiveResource;
import znaishaded.org.apache.ant.compress.util.ArchiveStreamFactory;
import znaishaded.org.apache.ant.compress.util.ZipStreamFactory;
import znaishaded.org.apache.commons.compress.archivers.ArchiveEntry;
import znaishaded.org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import znaishaded.org.apache.commons.compress.archivers.zip.ZipExtraField;
import znaishaded.org.apache.commons.compress.archivers.zip.ZipFile;
import znaishaded.org.apache.tools.ant.BuildException;
import znaishaded.org.apache.tools.ant.types.Resource;
import znaishaded.org.apache.tools.ant.types.resources.FileProvider;
import znaishaded.org.apache.tools.ant.util.FileUtils;

public final class ZipResource
extends CommonsCompressArchiveResource {
    private ZipExtraField[] extras;
    private int method;

    public ZipResource() {
        super(new ZipStreamFactory(), "zip");
    }

    public ZipResource(File z, String enc, ZipArchiveEntry e) {
        super((ArchiveStreamFactory)new ZipStreamFactory(), "zip", z, (ArchiveEntry)e);
        this.setEncoding(enc);
        this.setEntry(e);
    }

    public ZipResource(Resource z, String enc, ZipArchiveEntry e) {
        super((ArchiveStreamFactory)new ZipStreamFactory(), "zip", z, (ArchiveEntry)e);
        this.setEncoding(enc);
        this.setEntry(e);
    }

    public void setZipfile(File z) {
        this.setArchive(z);
    }

    public void setZipResource(Resource z) {
        this.addConfigured(z);
    }

    public File getZipfile() {
        FileProvider fp = this.getArchive().as(FileProvider.class);
        return fp != null ? fp.getFile() : null;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.isReference()) {
            return ((Resource)this.getCheckedRef()).getInputStream();
        }
        File f = this.getZipfile();
        if (f == null) {
            return super.getInputStream();
        }
        final ZipFile z = new ZipFile(f, this.getEncoding());
        ZipArchiveEntry ze = z.getEntry(this.getName());
        if (ze == null) {
            z.close();
            throw new BuildException("no entry " + this.getName() + " in " + this.getArchive());
        }
        return new FilterInputStream(z.getInputStream(ze)){

            @Override
            public void close() throws IOException {
                FileUtils.close(this.in);
                z.close();
            }

            protected void finalize() throws Throwable {
                try {
                    this.close();
                }
                finally {
                    super.finalize();
                }
            }
        };
    }

    public ZipExtraField[] getExtraFields() {
        if (this.isReference()) {
            return ((ZipResource)this.getCheckedRef()).getExtraFields();
        }
        this.checkEntry();
        if (this.extras == null) {
            return new ZipExtraField[0];
        }
        return this.extras;
    }

    public int getMethod() {
        return this.method;
    }

    @Override
    protected void fetchEntry() {
        File f = this.getZipfile();
        if (f == null) {
            super.fetchEntry();
            return;
        }
        try (ZipFile z = new ZipFile(this.getZipfile(), this.getEncoding());){
            this.setEntry(z.getEntry(this.getName()));
        }
        catch (IOException e) {
            this.log(e.getMessage(), 4);
            throw new BuildException(e);
        }
    }

    @Override
    protected void setEntry(ArchiveEntry e) {
        super.setEntry(e);
        if (e != null) {
            ZipArchiveEntry ze = (ZipArchiveEntry)e;
            this.extras = ze.getExtraFields(true);
            this.method = ze.getMethod();
        }
    }
}

