/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.doxygen.parser;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.doxygen.parser.DoxygenDescription;
import org.testingisdocumenting.znai.doxygen.parser.DoxygenMember;

public class DoxygenCompound {
    private final Map<String, DoxygenMember> memberById = new LinkedHashMap<String, DoxygenMember>();
    private String id;
    private String kind;
    private String name;
    private DoxygenDescription description;

    public void setId(String id) {
        this.id = id;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(DoxygenDescription description) {
        this.description = description;
    }

    public String getId() {
        return this.id;
    }

    public String getKind() {
        return this.kind;
    }

    public String getName() {
        return this.name;
    }

    public DoxygenDescription getDescription() {
        return this.description;
    }

    public void addMember(DoxygenMember member) {
        this.memberById.put(member.getId(), member);
    }

    public DoxygenMember findById(String id) {
        return this.memberById.get(id);
    }

    public DoxygenMember findByFullName(String fullName) {
        return this.membersStream().filter(m3 -> fullName.equals(m3.getFullName())).findFirst().orElse(null);
    }

    public Stream<DoxygenMember> membersStream() {
        return this.memberById.values().stream();
    }

    public Stream<DoxygenMember> publicNonStaticFunctionsStream() {
        return this.publicFunctionsStream().filter(member -> !member.isStatic());
    }

    public Stream<DoxygenMember> protectedFunctionsStream() {
        return this.filterStream(DoxygenMember::isProtected);
    }

    public Stream<DoxygenMember> publicStaticFunctionsStream() {
        return this.publicFunctionsStream().filter(DoxygenMember::isStatic);
    }

    public Stream<DoxygenMember> publicNonStaticAttributesStream() {
        return this.publicAttributesStream().filter(member -> !member.isStatic());
    }

    public Stream<DoxygenMember> publicStaticAttributesStream() {
        return this.publicAttributesStream().filter(DoxygenMember::isStatic);
    }

    public Stream<DoxygenMember> publicAttributesStream() {
        return this.filterStream(member -> member.isVariable() && member.isPublic());
    }

    public Stream<DoxygenMember> publicFunctionsStream() {
        return this.filterStream(member -> member.isFunction() && member.isPublic());
    }

    private Stream<DoxygenMember> filterStream(Predicate<DoxygenMember> predicate) {
        return this.memberById.values().stream().filter(predicate);
    }
}

