/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.doxygen.parser;

import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.doxygen.parser.DoxygenBriefDescription;
import org.testingisdocumenting.znai.doxygen.parser.DoxygenCodeBlockSimple;
import org.testingisdocumenting.znai.doxygen.parser.DoxygenDescriptionParamsParser;
import org.testingisdocumenting.znai.doxygen.parser.DoxygenFullDescription;
import org.testingisdocumenting.znai.doxygen.parser.DoxygenParameterList;
import org.testingisdocumenting.znai.doxygen.parser.DoxygenProgramListingParser;
import org.testingisdocumenting.znai.doxygen.parser.DoxygenReturn;
import org.testingisdocumenting.znai.doxygen.parser.DoxygenReturnParser;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.api.ApiLinkedText;
import org.testingisdocumenting.znai.extensions.api.ApiParameters;
import org.testingisdocumenting.znai.parser.docelement.DocElement;
import org.testingisdocumenting.znai.parser.docelement.DocElementCreationParserHandler;
import org.testingisdocumenting.znai.reference.DocReferences;
import org.testingisdocumenting.znai.utils.XmlUtils;
import org.w3c.dom.Node;

public class DoxygenDescriptionParser {
    private final ComponentsRegistry componentsRegistry;
    private final DoxygenParameterList parameters;
    private final String paramsAnchorPrefix;
    private final Node descriptionRoot;
    private final List<String> textParts;
    private DocElementCreationParserHandler parserHandler;
    private ApiParameters apiParameters;
    private ApiParameters apiTemplateParameters;
    private DoxygenReturn doxygenReturn;

    private DoxygenDescriptionParser(ComponentsRegistry componentsRegistry, DoxygenParameterList parameters, String paramsAnchorPrefix, Node descriptionNode) {
        this.componentsRegistry = componentsRegistry;
        this.parameters = parameters;
        this.paramsAnchorPrefix = paramsAnchorPrefix;
        this.descriptionRoot = descriptionNode;
        this.textParts = new ArrayList<String>();
    }

    public static DoxygenFullDescription parseFull(ComponentsRegistry componentsRegistry, DoxygenParameterList parameters, String paramsAnchorPrefix, Node descriptionNode) {
        DoxygenDescriptionParser parser = new DoxygenDescriptionParser(componentsRegistry, parameters, paramsAnchorPrefix, descriptionNode);
        return parser.parseFullDescription();
    }

    public static DoxygenBriefDescription parseBrief(ComponentsRegistry componentsRegistry, Node briefDescriptionNode) {
        DoxygenDescriptionParser parser = new DoxygenDescriptionParser(componentsRegistry, new DoxygenParameterList(), "", briefDescriptionNode);
        return parser.parseBriefDescription();
    }

    private DoxygenFullDescription parseFullDescription() {
        this.parserHandler = new DocElementCreationParserHandler(this.componentsRegistry, Paths.get("doxygen-xml", new String[0]));
        this.parseChildren(this.descriptionRoot);
        this.parserHandler.onParsingEnd();
        if (this.apiParameters != null && this.doxygenReturn != null) {
            this.apiParameters.addInFront("return", new ApiLinkedText(), this.doxygenReturn.getDocElementList().stream().map(DocElement::toMap).collect(Collectors.toList()), this.doxygenReturn.getTextForSearch());
        }
        return new DoxygenFullDescription(this.parserHandler.getDocElement().getContent(), this.apiParameters, this.apiTemplateParameters, String.join((CharSequence)" ", this.textParts));
    }

    private DoxygenBriefDescription parseBriefDescription() {
        this.parserHandler = new DocElementCreationParserHandler(this.componentsRegistry, Paths.get("doxygen-xml", new String[0]));
        this.parseChildren(this.descriptionRoot);
        this.parserHandler.onParsingEnd();
        return new DoxygenBriefDescription(this.parserHandler.getDocElement().getContent(), String.join((CharSequence)" ", this.textParts));
    }

    private void parseChildren(Node node) {
        XmlUtils.forEach(node.getChildNodes(), this::handleDescriptionNode);
    }

    private void handleDescriptionNode(Node node) {
        String textContent;
        String textContentTrimmed;
        String nodeName = node.getNodeName();
        if (nodeName.equals("para")) {
            this.parserHandler.onParagraphStart();
            this.parseChildren(node);
            this.parserHandler.onParagraphEnd();
        } else if (nodeName.equals("parameterlist")) {
            String kind = XmlUtils.getAttributeText(node, "kind");
            if ("param".equals(kind)) {
                this.apiParameters = DoxygenDescriptionParamsParser.parseParameters(this.componentsRegistry, this.parameters, this.paramsAnchorPrefix, node);
            } else if ("templateparam".equals(kind)) {
                this.apiTemplateParameters = DoxygenDescriptionParamsParser.parseParameters(this.componentsRegistry, this.parameters, this.paramsAnchorPrefix + "_template", node);
            }
            this.parseChildren(node);
        } else if (nodeName.equals("programlisting")) {
            DoxygenCodeBlockSimple codeBlockSimple = DoxygenProgramListingParser.parseAsSimpleCodeBlock(node);
            this.parserHandler.onSnippet(PluginParams.EMPTY, codeBlockSimple.getExtension(), "", codeBlockSimple.getCode());
        } else if (nodeName.equals("computeroutput")) {
            String textContent2 = node.getTextContent();
            this.parserHandler.onInlinedCode(textContent2, DocReferences.EMPTY);
            this.textParts.add(textContent2);
        } else if (nodeName.equals("simplesect")) {
            String kind = XmlUtils.getAttributeText(node, "kind");
            if ("return".equals(kind)) {
                this.doxygenReturn = DoxygenReturnParser.parse(this.componentsRegistry, node);
            } else if ("note".equals(kind)) {
                LinkedHashMap<String, String> attrs = new LinkedHashMap<String, String>();
                attrs.put("attentionType", "note");
                this.parserHandler.onCustomNodeStart("AttentionBlock", attrs);
                this.parseChildren(node);
                this.parserHandler.onCustomNodeEnd("AttentionBlock");
            }
        } else if (nodeName.equals("bold")) {
            this.parserHandler.onStrongEmphasisStart();
            this.parseChildren(node);
            this.parserHandler.onStrongEmphasisEnd();
        } else if (nodeName.equals("emphasis")) {
            this.parserHandler.onEmphasisStart();
            this.parseChildren(node);
            this.parserHandler.onEmphasisEnd();
        } else if (nodeName.equals("itemizedlist")) {
            this.parserHandler.onBulletListStart('*', false);
            this.parseChildren(node);
            this.parserHandler.onBulletListEnd();
        } else if (nodeName.equals("orderedlist")) {
            this.parserHandler.onOrderedListStart(' ', 1);
            this.parseChildren(node);
            this.parserHandler.onOrderedListEnd();
        } else if (nodeName.equals("listitem")) {
            this.parserHandler.onListItemStart();
            this.parseChildren(node);
            this.parserHandler.onListItemEnd();
        } else if (node.getNodeType() == 3 && !(textContentTrimmed = (textContent = node.getTextContent()).trim()).isEmpty()) {
            this.parserHandler.onSimpleText(textContent);
            this.textParts.add(textContentTrimmed);
        }
    }
}

