/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.enterprise.authorization;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.testingisdocumenting.znai.console.ConsoleOutputs;
import org.testingisdocumenting.znai.core.DocMeta;
import org.testingisdocumenting.znai.enterprise.DocLifecycleListener;
import org.testingisdocumenting.znai.enterprise.EnterpriseComponentsRegistry;
import org.testingisdocumenting.znai.enterprise.authorization.AllowedUsersAndGroups;
import org.testingisdocumenting.znai.enterprise.authorization.UserIdDocId;
import org.testingisdocumenting.znai.enterprise.authorization.groups.AuthorizationGroupResolutionServices;
import org.testingisdocumenting.znai.server.auth.AuthorizationHandler;
import org.testingisdocumenting.znai.server.auth.AuthorizationRequestLink;
import znaishaded.com.github.benmanes.caffeine.cache.Cache;
import znaishaded.com.github.benmanes.caffeine.cache.Caffeine;

public class EnterpriseAuthorizationHandler
implements AuthorizationHandler,
DocLifecycleListener {
    private Cache<UserIdDocId, Boolean> authorizedByIds;
    private final Map<String, AllowedUsersAndGroups> allowedUsersAndGroupsById = new ConcurrentHashMap<String, AllowedUsersAndGroups>();

    public EnterpriseAuthorizationHandler() {
        if (this.disabled()) {
            return;
        }
        this.authorizedByIds = Caffeine.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).build();
        this.buildAllowedUsersAndGroupsCache();
    }

    @Override
    public boolean isAuthorized(String userId, String docId) {
        if (AuthorizationGroupResolutionServices.isEmpty()) {
            ConsoleOutputs.out("AuthorizationGroupResolutionServices.isEmpty(): no authorization is being performed for <" + docId + ">");
            return true;
        }
        AllowedUsersAndGroups allowedUsersAndGroups = this.allowedUsersAndGroupsById.get(docId);
        if (allowedUsersAndGroups == null || allowedUsersAndGroups.isEmpty()) {
            ConsoleOutputs.out("allowed users and groups is empty: no authorization is being performed for <" + docId + ">");
            return true;
        }
        if (allowedUsersAndGroups.containsUser(userId)) {
            return true;
        }
        if (allowedUsersAndGroups.getAllowedGroups().isEmpty()) {
            return false;
        }
        Boolean present = this.authorizedByIds.get(new UserIdDocId(userId, docId), userIdDocId -> this.authorized(allowedUsersAndGroups, userId));
        return present != null && present != false;
    }

    @Override
    public List<String> allowedGroups(String docId) {
        AllowedUsersAndGroups allowedUsersAndGroups = this.allowedUsersAndGroupsById.get(docId);
        if (allowedUsersAndGroups == null) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(allowedUsersAndGroups.getAllowedGroups());
    }

    @Override
    public AuthorizationRequestLink authorizationRequestLink() {
        return EnterpriseComponentsRegistry.enterpriseConfig().getAuthzRequestLink();
    }

    @Override
    public void onDocUpdate(DocMeta docMeta) {
        this.allowedUsersAndGroupsById.put(docMeta.getId(), this.createAllowedUsersAndGroups(docMeta));
    }

    @Override
    public void onDocRemove(String docId) {
        this.allowedUsersAndGroupsById.remove(docId);
    }

    private void buildAllowedUsersAndGroupsCache() {
        EnterpriseComponentsRegistry.documentationStorage().list().forEach(this::associatedAllowedById);
    }

    private void associatedAllowedById(DocMeta docMeta) {
        this.allowedUsersAndGroupsById.put(docMeta.getId(), this.createAllowedUsersAndGroups(docMeta));
    }

    private AllowedUsersAndGroups createAllowedUsersAndGroups(DocMeta docMeta) {
        return new AllowedUsersAndGroups(new HashSet<String>(docMeta.getAllowedUsers()), new HashSet<String>(docMeta.getAllowedGroups()));
    }

    private Boolean authorized(AllowedUsersAndGroups allowedUsersAndGroups, String userId) {
        return allowedUsersAndGroups.getAllowedGroups().stream().anyMatch(group -> this.inGroup((String)group, userId));
    }

    private boolean inGroup(String group, String userId) {
        return AuthorizationGroupResolutionServices.groupContainsUser(group, userId);
    }

    private boolean disabled() {
        return EnterpriseComponentsRegistry.documentationStorage() == null;
    }
}

