/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginParamsFactory;
import org.testingisdocumenting.znai.extensions.Plugins;
import org.testingisdocumenting.znai.structure.PageMeta;
import org.testingisdocumenting.znai.utils.JsonUtils;

public class PluginParamsWithDefaultsFactory
implements PluginParamsFactory {
    private final Map<String, ?> emptyParams = Collections.emptyMap();
    private final Map<String, Map<String, ?>> globalParams = new HashMap();
    private final ThreadLocal<Map<String, Map<String, ?>>> pageLocalParams = ThreadLocal.withInitial(HashMap::new);

    @Override
    public PluginParams create(String pluginId, String freeParam, Map<String, ?> opts) {
        Map<String, ?> globalPluginDefaults = this.globalParams.getOrDefault(pluginId, this.emptyParams);
        Map<String, ?> localPluginDefaults = this.pageLocalParams.get().getOrDefault(pluginId, this.emptyParams);
        LinkedHashMap combinedOpts = new LinkedHashMap();
        combinedOpts.putAll(globalPluginDefaults);
        combinedOpts.putAll(localPluginDefaults);
        combinedOpts.putAll(opts);
        return new PluginParams(pluginId, freeParam, combinedOpts);
    }

    public void setGlobalParams(Map<String, Map<String, ?>> globalParams) {
        this.globalParams.clear();
        this.globalParams.putAll(globalParams);
    }

    public void setPageLocalParams(PageMeta pageMeta) {
        HashMap pageLocalParams = new HashMap();
        for (String potentialPluginId : pageMeta.keySet()) {
            if (!Plugins.hasPlugin(potentialPluginId)) continue;
            Object value = pageMeta.getSingleValue(potentialPluginId);
            Map<String, ?> localParams = JsonUtils.deserializeAsMap(value.toString());
            pageLocalParams.put(potentialPluginId, localParams);
        }
        this.setPageLocalParams(pageLocalParams);
    }

    private void setPageLocalParams(Map<String, Map<String, ?>> pageLocalParams) {
        Map<String, Map<String, ?>> local = this.pageLocalParams.get();
        local.clear();
        local.putAll(pageLocalParams);
    }
}

