/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.api;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.testingisdocumenting.znai.extensions.api.ApiLinkedText;
import org.testingisdocumenting.znai.extensions.api.ApiParameter;
import org.testingisdocumenting.znai.extensions.api.ApiParametersAnchors;

public class ApiParameters {
    private final ApiParameter root;
    private String example;

    public ApiParameters(String anchorPrefix) {
        this.root = new ApiParameter(ApiParametersAnchors.sanitizeAnchorId(anchorPrefix), "root", new ApiLinkedText("root"), Collections.emptyList(), "");
    }

    public ApiParameter addInFront(String name, ApiLinkedText type, List<Map<String, Object>> description, String textForSearch) {
        return this.root.addInFront(name, type, description, textForSearch);
    }

    public ApiParameter add(String name, ApiLinkedText type, List<Map<String, Object>> description, String textForSearch) {
        return this.root.add(name, type, description, textForSearch);
    }

    public void add(ApiParameter parameter) {
        this.root.add(parameter);
    }

    public ApiParameter find(String name) {
        return this.root.find(name);
    }

    public String getAnchorId() {
        return this.root.getAnchorId();
    }

    public String getExample() {
        return this.example;
    }

    public void setExample(String example) {
        this.example = example;
    }

    public ApiParameters withoutTopLevel() {
        ApiParameters result = new ApiParameters(this.root.getAnchorId());
        result.example = this.example;
        if (this.root.getChildren().isEmpty()) {
            return result;
        }
        ApiParameter firstChild = this.root.getChildren().get(0);
        firstChild.getChildren().forEach(result::add);
        return result;
    }

    public ApiParameter getRoot() {
        return this.root;
    }

    public boolean isEmpty() {
        return this.root.getChildren().isEmpty();
    }

    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("parameters", this.root.getChildren().stream().map(ApiParameter::toMap).collect(Collectors.toList()));
        if (this.example != null) {
            result.put("example", this.example);
        }
        return result;
    }

    public List<String> collectAllAnchors() {
        return this.root.getChildren().stream().flatMap(child -> child.collectAllAnchors().stream()).collect(Collectors.toList());
    }

    public String combinedTextForSearch() {
        return this.root.getChildren().stream().map(ApiParameter::combinedTextForSearch).collect(Collectors.joining(" "));
    }
}

