/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.cli;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.core.AuxiliaryFile;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginParamsDefinition;
import org.testingisdocumenting.znai.extensions.PluginParamsDefinitionCommon;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.features.PluginFeatureList;
import org.testingisdocumenting.znai.extensions.file.ManipulatedSnippetContentProvider;
import org.testingisdocumenting.znai.extensions.file.SnippetHighlightFeature;
import org.testingisdocumenting.znai.extensions.file.SnippetRevealLineStopFeature;
import org.testingisdocumenting.znai.extensions.file.SnippetsCommon;
import org.testingisdocumenting.znai.extensions.include.IncludePlugin;
import org.testingisdocumenting.znai.parser.ParserHandler;
import org.testingisdocumenting.znai.resources.ResourcesResolver;
import org.testingisdocumenting.znai.search.SearchScore;
import org.testingisdocumenting.znai.search.SearchText;

public class CliOutputIncludePlugin
implements IncludePlugin {
    private Path filePath;
    private ManipulatedSnippetContentProvider contentProvider;
    private PluginFeatureList features;

    @Override
    public String id() {
        return "cli-output";
    }

    @Override
    public IncludePlugin create() {
        return new CliOutputIncludePlugin();
    }

    @Override
    public PluginParamsDefinition parameters() {
        return new PluginParamsDefinition().add(PluginParamsDefinitionCommon.container).add(PluginParamsDefinitionCommon.snippetWide).add(PluginParamsDefinitionCommon.snippetReadMore).add(ManipulatedSnippetContentProvider.paramsDefinition).add(SnippetHighlightFeature.paramsDefinition).add(SnippetRevealLineStopFeature.paramsDefinition);
    }

    @Override
    public PluginResult process(ComponentsRegistry componentsRegistry, ParserHandler parserHandler, Path markupPath, PluginParams pluginParams) {
        ResourcesResolver resourcesResolver = componentsRegistry.resourceResolver();
        String fileName = pluginParams.getFreeParam();
        this.filePath = resourcesResolver.fullPath(fileName);
        String content = componentsRegistry.resourceResolver().textContent(this.filePath);
        this.contentProvider = new ManipulatedSnippetContentProvider(fileName, content, pluginParams);
        this.features = new PluginFeatureList(SnippetsCommon.createCommonFeatures(componentsRegistry, markupPath, pluginParams, this.contentProvider).asList());
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>(pluginParams.getOpts().toMap());
        List<String> lines = Arrays.asList(this.contentProvider.snippetContent().split("\n"));
        props.put("lines", lines);
        props.putAll(pluginParams.getOpts().toMap());
        this.features.updateProps(props);
        return PluginResult.docElement("CliOutput", props);
    }

    @Override
    public Stream<AuxiliaryFile> auxiliaryFiles(ComponentsRegistry componentsRegistry) {
        return Stream.concat(Stream.of(AuxiliaryFile.builtTime(this.filePath)), this.features.auxiliaryFiles());
    }

    @Override
    public SearchText textForSearch() {
        return SearchScore.STANDARD.text(this.contentProvider.snippetContent());
    }
}

