/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.ocaml;

import java.nio.file.Path;
import java.util.regex.Pattern;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.parser.MarkupParser;
import org.testingisdocumenting.znai.parser.MarkupParserResult;
import org.testingisdocumenting.znai.utils.RegexpUtils;
import org.testingisdocumenting.znai.utils.StringUtils;

class OcamlCommentExtractor {
    private final String[] lines;
    private final String content;

    OcamlCommentExtractor(String content) {
        this.content = content;
        this.lines = content.split("\n");
    }

    String extractCommentBlock(String textToMatch) {
        int idx = this.findIdxWithMatch(textToMatch);
        int startBlockIdx = this.startCommentBlockIdx(idx);
        int endBlockIdx = this.endCommentBlockIdx(startBlockIdx);
        return this.removeCommentPrefixAndSuffix(this.extractBlock(startBlockIdx, endBlockIdx));
    }

    MarkupParserResult extractCommentBlockAsDocElements(ComponentsRegistry componentsRegistry, Path filePath, String textToMatch) {
        String commentText = this.extractCommentBlock(textToMatch);
        String processedText = this.processOcamlDocSyntax(commentText);
        MarkupParser parser = componentsRegistry.defaultParser();
        return parser.parse(filePath, processedText);
    }

    private String removeCommentPrefixAndSuffix(String commentBlock) {
        String trimmed = commentBlock.trim();
        int startIndex = trimmed.startsWith("(**") ? 3 : 2;
        String withoutDelimiters = trimmed.substring(startIndex, trimmed.length() - 2);
        return withoutDelimiters.trim();
    }

    private String extractBlock(int startBlockIdx, int endBlockIdx) {
        StringBuilder result = new StringBuilder();
        for (int i = startBlockIdx; i <= endBlockIdx; ++i) {
            result.append(this.lines[i]);
            if (i >= endBlockIdx) continue;
            result.append("\n");
        }
        return result.toString();
    }

    private int startCommentBlockIdx(int idx) {
        while (idx >= 0) {
            if (this.lines[idx].contains("(*")) {
                return idx;
            }
            --idx;
        }
        throw new IllegalArgumentException("can't find comment block start, starting idx: " + idx + this.contentPartForException());
    }

    private int endCommentBlockIdx(int idx) {
        while (idx < this.lines.length) {
            if (this.lines[idx].contains("*)")) {
                return idx;
            }
            ++idx;
        }
        throw new IllegalArgumentException("can't find comment block end, starting idx: " + idx + this.contentPartForException());
    }

    int findIdxWithMatch(String textToMatch) {
        for (int idx = 0; idx < this.lines.length; ++idx) {
            if (!this.lines[idx].contains(textToMatch)) continue;
            return idx;
        }
        throw new IllegalArgumentException("can't find text: " + textToMatch + this.contentPartForException());
    }

    private String contentPartForException() {
        return ", content:\n" + this.content;
    }

    String processOcamlDocSyntax(String text) {
        Pattern multiLineCodePattern = Pattern.compile("\\{\\[([^}]*?)]}", 32);
        String afterMultiLine = RegexpUtils.replaceAll(text, multiLineCodePattern, matcher -> {
            String codeContent = matcher.group(1);
            codeContent = codeContent.replaceAll("^\\s*\\n", "").replaceAll("\\n\\s*$", "");
            codeContent = StringUtils.stripIndentation(codeContent);
            return "\n```\n" + codeContent + "\n```";
        });
        String[] parts = afterMultiLine.split("```", -1);
        StringBuilder finalResult = new StringBuilder();
        Pattern inlineCodePattern = Pattern.compile("\\[([^]]+?)]");
        for (int i = 0; i < parts.length; ++i) {
            if (i % 2 == 0) {
                String currentPart = parts[i];
                String part = RegexpUtils.replaceAll(currentPart, inlineCodePattern, matcher -> {
                    String code = matcher.group(1);
                    return "`" + code + "`";
                });
                finalResult.append(part);
            } else {
                finalResult.append(parts[i]);
            }
            if (i >= parts.length - 1) continue;
            finalResult.append("```");
        }
        return finalResult.toString();
    }
}

