/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.ocaml;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.ref.SoftReference;
import java.nio.file.Paths;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.testingisdocumenting.webtau.WebTauCore;
import org.testingisdocumenting.znai.parser.TestComponentsRegistry;
import znaishaded.org.junit.Test;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class OcamlCommentExtractorTest
implements GroovyObject {
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;
    private static /* synthetic */ Class $class$org$testingisdocumenting$znai$extensions$ocaml$OcamlCommentExtractor;

    @Generated
    public OcamlCommentExtractorTest() {
        MetaClass metaClass;
        CallSite[] callSiteArray = OcamlCommentExtractorTest.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @Test
    public void extract single line comment block() {
        CallSite[] callSiteArray = OcamlCommentExtractorTest.$getCallSiteArray();
        String content = "\n(* This is a comment *)\nlet x = 5\n";
        Object extractor = callSiteArray[0].callConstructor((Object)OcamlCommentExtractorTest.$get$$class$org$testingisdocumenting$znai$extensions$ocaml$OcamlCommentExtractor(), (Object)content);
        Object result = callSiteArray[1].call(extractor, (Object)"let x");
        callSiteArray[2].call(result, callSiteArray[3].callStatic(WebTauCore.class, (Object)"This is a comment"));
    }

    @Test
    public void extract multi line comment block() {
        CallSite[] callSiteArray = OcamlCommentExtractorTest.$getCallSiteArray();
        String content = "\n(* This is a \n   multi-line\n   comment *)\nlet y = 10\n";
        Object extractor = callSiteArray[4].callConstructor((Object)OcamlCommentExtractorTest.$get$$class$org$testingisdocumenting$znai$extensions$ocaml$OcamlCommentExtractor(), (Object)content);
        Object result = callSiteArray[5].call(extractor, (Object)"let y");
        callSiteArray[6].call(result, callSiteArray[7].callStatic(WebTauCore.class, (Object)"This is a \n   multi-line\n   comment"));
    }

    @Test
    public void extract comment block with code in between() {
        CallSite[] callSiteArray = OcamlCommentExtractorTest.$getCallSiteArray();
        String content = "\nlet a = 1\n(* Comment for function *)\nlet myFunc x = x + 1\nlet b = 2\n";
        Object extractor = callSiteArray[8].callConstructor((Object)OcamlCommentExtractorTest.$get$$class$org$testingisdocumenting$znai$extensions$ocaml$OcamlCommentExtractor(), (Object)content);
        Object result = callSiteArray[9].call(extractor, (Object)"myFunc");
        callSiteArray[10].call(result, callSiteArray[11].callStatic(WebTauCore.class, (Object)"Comment for function"));
    }

    @Test
    public void extract documentation comment with double asterisk() {
        CallSite[] callSiteArray = OcamlCommentExtractorTest.$getCallSiteArray();
        String content = "\n(** This is a documentation comment *)\nlet docFunc x = x * 2\n";
        Object extractor = callSiteArray[12].callConstructor((Object)OcamlCommentExtractorTest.$get$$class$org$testingisdocumenting$znai$extensions$ocaml$OcamlCommentExtractor(), (Object)content);
        Object result = callSiteArray[13].call(extractor, (Object)"docFunc");
        callSiteArray[14].call(result, callSiteArray[15].callStatic(WebTauCore.class, (Object)"This is a documentation comment"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void throw exception when text not found() {
        CallSite[] callSiteArray = OcamlCommentExtractorTest.$getCallSiteArray();
        String content = "\n(* Some comment *)\nlet x = 5\n";
        Object extractor = callSiteArray[16].callConstructor((Object)OcamlCommentExtractorTest.$get$$class$org$testingisdocumenting$znai$extensions$ocaml$OcamlCommentExtractor(), (Object)content);
        callSiteArray[17].call(extractor, (Object)"nonexistent");
    }

    @Test(expected=IllegalArgumentException.class)
    public void throw exception when no comment block found before match() {
        CallSite[] callSiteArray = OcamlCommentExtractorTest.$getCallSiteArray();
        String content = "\nlet x = 5\nlet y = 10\n";
        Object extractor = callSiteArray[18].callConstructor((Object)OcamlCommentExtractorTest.$get$$class$org$testingisdocumenting$znai$extensions$ocaml$OcamlCommentExtractor(), (Object)content);
        callSiteArray[19].call(extractor, (Object)"let x");
    }

    @Test
    public void convert OCaml inline code syntax to markdown() {
        CallSite[] callSiteArray = OcamlCommentExtractorTest.$getCallSiteArray();
        Object extractor = callSiteArray[20].callConstructor((Object)OcamlCommentExtractorTest.$get$$class$org$testingisdocumenting$znai$extensions$ocaml$OcamlCommentExtractor(), (Object)"");
        callSiteArray[21].call(callSiteArray[22].call(extractor, (Object)"Use [List.map] to transform"), callSiteArray[23].callStatic(WebTauCore.class, (Object)"Use `List.map` to transform"));
        callSiteArray[24].call(callSiteArray[25].call(extractor, (Object)"Check [fold_left] and [fold_right]"), callSiteArray[26].callStatic(WebTauCore.class, (Object)"Check `fold_left` and `fold_right`"));
    }

    @Test
    public void convert OCaml multi-line code blocks to markdown() {
        CallSite[] callSiteArray = OcamlCommentExtractorTest.$getCallSiteArray();
        Object extractor = callSiteArray[27].callConstructor((Object)OcamlCommentExtractorTest.$get$$class$org$testingisdocumenting$znai$extensions$ocaml$OcamlCommentExtractor(), (Object)"");
        String input = "Example:\n{[\n  let x = 1\n  let y = 2\n]}";
        String expected = "Example:\n\n```\nlet x = 1\nlet y = 2\n```";
        callSiteArray[28].call(callSiteArray[29].call(extractor, (Object)input), callSiteArray[30].callStatic(WebTauCore.class, (Object)expected));
    }

    @Test
    public void handle multiple code blocks() {
        CallSite[] callSiteArray = OcamlCommentExtractorTest.$getCallSiteArray();
        Object extractor = callSiteArray[31].callConstructor((Object)OcamlCommentExtractorTest.$get$$class$org$testingisdocumenting$znai$extensions$ocaml$OcamlCommentExtractor(), (Object)"");
        String input = "First: {[let x = 1]}\nSecond: {[let y = 2]}";
        String expected = "First: \n```\nlet x = 1\n```\nSecond: \n```\nlet y = 2\n```";
        callSiteArray[32].call(callSiteArray[33].call(extractor, (Object)input), callSiteArray[34].callStatic(WebTauCore.class, (Object)expected));
    }

    @Test
    public void handle mixed OCaml and markdown syntax() {
        CallSite[] callSiteArray = OcamlCommentExtractorTest.$getCallSiteArray();
        Object extractor = callSiteArray[35].callConstructor((Object)OcamlCommentExtractorTest.$get$$class$org$testingisdocumenting$znai$extensions$ocaml$OcamlCommentExtractor(), (Object)"");
        String input = "## Header\n\nUse [fold_left] like this:\n{[\n  List.fold_left (+) 0 [1; 2; 3]\n]}\n\nafter";
        String expected = "## Header\n\nUse `fold_left` like this:\n\n```\nList.fold_left (+) 0 [1; 2; 3]\n```\n\nafter";
        callSiteArray[36].call(callSiteArray[37].call(extractor, (Object)input), callSiteArray[38].callStatic(WebTauCore.class, (Object)expected));
    }

    @Test
    public void convert full comment block to doc elements() {
        CallSite[] callSiteArray = OcamlCommentExtractorTest.$getCallSiteArray();
        String content = "\n(** Use [List.map] to transform elements *)\nlet transform lst = List.map (fun x -> x + 1) lst\n";
        Object extractor = callSiteArray[39].callConstructor((Object)OcamlCommentExtractorTest.$get$$class$org$testingisdocumenting$znai$extensions$ocaml$OcamlCommentExtractor(), (Object)content);
        Object elements = callSiteArray[40].call(callSiteArray[41].call(extractor, callSiteArray[42].callGetProperty(TestComponentsRegistry.class), callSiteArray[43].call(Paths.class, (Object)"test.ml"), (Object)"transform"));
        callSiteArray[44].call(callSiteArray[45].call(elements), callSiteArray[46].callStatic(WebTauCore.class, (Object)1));
        callSiteArray[47].call(callSiteArray[48].callGetProperty(callSiteArray[49].call(elements, (Object)0)), callSiteArray[50].callStatic(WebTauCore.class, (Object)"TestMarkup"));
        callSiteArray[51].call(callSiteArray[52].callGetProperty(callSiteArray[53].call(elements, (Object)0)), callSiteArray[54].callStatic(WebTauCore.class, (Object)"Use `List.map` to transform elements"));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != OcamlCommentExtractorTest.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "<$constructor$>";
        stringArray[1] = "extractCommentBlock";
        stringArray[2] = "should";
        stringArray[3] = "equal";
        stringArray[4] = "<$constructor$>";
        stringArray[5] = "extractCommentBlock";
        stringArray[6] = "should";
        stringArray[7] = "equal";
        stringArray[8] = "<$constructor$>";
        stringArray[9] = "extractCommentBlock";
        stringArray[10] = "should";
        stringArray[11] = "equal";
        stringArray[12] = "<$constructor$>";
        stringArray[13] = "extractCommentBlock";
        stringArray[14] = "should";
        stringArray[15] = "equal";
        stringArray[16] = "<$constructor$>";
        stringArray[17] = "extractCommentBlock";
        stringArray[18] = "<$constructor$>";
        stringArray[19] = "extractCommentBlock";
        stringArray[20] = "<$constructor$>";
        stringArray[21] = "should";
        stringArray[22] = "processOcamlDocSyntax";
        stringArray[23] = "equal";
        stringArray[24] = "should";
        stringArray[25] = "processOcamlDocSyntax";
        stringArray[26] = "equal";
        stringArray[27] = "<$constructor$>";
        stringArray[28] = "should";
        stringArray[29] = "processOcamlDocSyntax";
        stringArray[30] = "equal";
        stringArray[31] = "<$constructor$>";
        stringArray[32] = "should";
        stringArray[33] = "processOcamlDocSyntax";
        stringArray[34] = "equal";
        stringArray[35] = "<$constructor$>";
        stringArray[36] = "should";
        stringArray[37] = "processOcamlDocSyntax";
        stringArray[38] = "equal";
        stringArray[39] = "<$constructor$>";
        stringArray[40] = "contentToListOfMaps";
        stringArray[41] = "extractCommentBlockAsDocElements";
        stringArray[42] = "TEST_COMPONENTS_REGISTRY";
        stringArray[43] = "get";
        stringArray[44] = "should";
        stringArray[45] = "size";
        stringArray[46] = "equal";
        stringArray[47] = "should";
        stringArray[48] = "type";
        stringArray[49] = "getAt";
        stringArray[50] = "equal";
        stringArray[51] = "should";
        stringArray[52] = "markup";
        stringArray[53] = "getAt";
        stringArray[54] = "equal";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[55];
        OcamlCommentExtractorTest.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(OcamlCommentExtractorTest.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = OcamlCommentExtractorTest.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    private static /* synthetic */ Class $get$$class$org$testingisdocumenting$znai$extensions$ocaml$OcamlCommentExtractor() {
        Class clazz = $class$org$testingisdocumenting$znai$extensions$ocaml$OcamlCommentExtractor;
        if (clazz == null) {
            clazz = $class$org$testingisdocumenting$znai$extensions$ocaml$OcamlCommentExtractor = OcamlCommentExtractorTest.class$("org.testingisdocumenting.znai.extensions.ocaml.OcamlCommentExtractor");
        }
        return clazz;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

