/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.ocaml;

import java.nio.file.Path;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.core.AuxiliaryFile;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.extensions.PluginParamType;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginParamsDefinition;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.include.IncludePlugin;
import org.testingisdocumenting.znai.extensions.ocaml.OcamlCommentExtractor;
import org.testingisdocumenting.znai.parser.MarkupParserResult;
import org.testingisdocumenting.znai.parser.ParserHandler;
import org.testingisdocumenting.znai.search.SearchScore;
import org.testingisdocumenting.znai.search.SearchText;

public class OcamlCommentIncludePlugin
implements IncludePlugin {
    protected static final String COMMENT_LINE_KEY = "commentLine";
    private Path ocamlPath;
    private MarkupParserResult parserResult;

    @Override
    public String id() {
        return "ocaml-comment";
    }

    @Override
    public IncludePlugin create() {
        return new OcamlCommentIncludePlugin();
    }

    @Override
    public PluginParamsDefinition parameters() {
        PluginParamsDefinition params = new PluginParamsDefinition();
        params.add(COMMENT_LINE_KEY, PluginParamType.STRING, "text within a comment to match and identify the ocaml comment block", "\"to use this function\"");
        return params;
    }

    @Override
    public PluginResult process(ComponentsRegistry componentsRegistry, ParserHandler parserHandler, Path markupPath, PluginParams pluginParams) {
        String fileName = pluginParams.getFreeParam();
        this.ocamlPath = componentsRegistry.resourceResolver().fullPath(fileName);
        String text = componentsRegistry.resourceResolver().textContent(fileName);
        String commentLine = pluginParams.getOpts().getRequiredString(COMMENT_LINE_KEY);
        this.parserResult = new OcamlCommentExtractor(text).extractCommentBlockAsDocElements(componentsRegistry, markupPath, commentLine);
        return PluginResult.docElements(this.parserResult.docElement().getContent().stream());
    }

    @Override
    public SearchText textForSearch() {
        return SearchScore.STANDARD.text(this.parserResult.getAllText());
    }

    @Override
    public Stream<AuxiliaryFile> auxiliaryFiles(ComponentsRegistry componentsRegistry) {
        return Stream.of(AuxiliaryFile.builtTime(this.ocamlPath));
    }
}

