/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.html.reactjs;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.html.Deployer;
import org.testingisdocumenting.znai.html.reactjs.KatexFonts;
import org.testingisdocumenting.znai.website.WebResource;

public class ReactJsBundle {
    public static final ReactJsBundle INSTANCE = new ReactJsBundle();
    private final WebResource mainJs = WebResource.moduleFromResource("static/main.js");
    private final WebResource mainCss = WebResource.fromResource("static/main.css");
    private final WebResource katexCss = WebResource.fromResource("static/css/katex.min.css");
    private final List<WebResource> fonts;

    private ReactJsBundle() {
        Stream<WebResource> katexFonts = KatexFonts.LIST.stream().map(name -> WebResource.fromResource("static/css/fonts/" + name));
        this.fonts = katexFonts.collect(Collectors.toList());
    }

    public Stream<WebResource> clientJavaScripts() {
        return Stream.of(this.mainJs);
    }

    public Stream<WebResource> clientCssResources() {
        return Stream.of(this.katexCss, this.mainCss);
    }

    public void deploy(Deployer deployer) {
        Stream.concat(Stream.concat(this.clientJavaScripts(), this.clientCssResources()), this.fonts.stream()).forEach(deployer::deploy);
    }
}

