/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.jupyter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.testingisdocumenting.znai.jupyter.JupyterCell;

public class JupyterCellFilter {
    public static List<JupyterCell> fromSection(List<JupyterCell> cells, String sectionName) {
        return JupyterCellFilter.fromSection(cells, sectionName, false);
    }

    public static List<JupyterCell> fromSection(List<JupyterCell> cells, String sectionName, boolean excludeSectionTitle) {
        JupyterCell cell;
        int i;
        int startIdx = -1;
        int endIdx = cells.size();
        for (i = 0; i < cells.size(); ++i) {
            cell = cells.get(i);
            if (!cell.getType().equals("markdown") || cell.getInput() == null || !JupyterCellFilter.firstLineTrimmed(cell.getInput()).matches("^#+\\s+" + Pattern.quote(sectionName))) continue;
            startIdx = i;
            break;
        }
        if (startIdx == -1) {
            return new ArrayList<JupyterCell>();
        }
        for (i = startIdx + 1; i < cells.size(); ++i) {
            cell = cells.get(i);
            if (!cell.getType().equals("markdown") || cell.getInput() == null || !JupyterCellFilter.firstLineTrimmed(cell.getInput()).matches("^#+ .*")) continue;
            endIdx = i;
            break;
        }
        ArrayList<JupyterCell> sectionCells = new ArrayList<JupyterCell>();
        for (int i2 = startIdx; i2 < endIdx; ++i2) {
            sectionCells.add(cells.get(i2));
        }
        return excludeSectionTitle ? JupyterCellFilter.excludeSectionHeader(sectionCells) : sectionCells;
    }

    private static String firstLineTrimmed(String input) {
        return (input = input.trim()).contains("\n") ? input.substring(0, input.indexOf("\n")) : input;
    }

    private static String stripFirstSectionHeader(String content) {
        String[] lines = content.split("\\n");
        int firstMatchIdx = 0;
        for (String line : lines) {
            if (line.strip().startsWith("#")) break;
            ++firstMatchIdx;
        }
        return Arrays.stream(lines).skip(firstMatchIdx + 1).collect(Collectors.joining("\n")).trim();
    }

    private static List<JupyterCell> excludeSectionHeader(List<JupyterCell> cells) {
        if (cells.isEmpty()) {
            return cells;
        }
        ArrayList<JupyterCell> result = new ArrayList<JupyterCell>();
        JupyterCell firstCell = cells.get(0);
        if (firstCell.getType().equals("markdown") && firstCell.getInput() != null) {
            String markdown = firstCell.getInput();
            String stripped = JupyterCellFilter.stripFirstSectionHeader(markdown);
            if (!stripped.isEmpty()) {
                result.add(new JupyterCell(firstCell.getType(), stripped, firstCell.getOutputs()));
            }
        } else {
            result.add(firstCell);
        }
        result.addAll(cells.subList(1, cells.size()));
        return result;
    }
}

