/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.markdown;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.ref.SoftReference;
import java.nio.file.Paths;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.testingisdocumenting.webtau.WebTauCore;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.include.DummyIncludePlugin;
import org.testingisdocumenting.znai.markdown.MarkdownGeneratorParserHandler;
import org.testingisdocumenting.znai.parser.MarkupParser;
import org.testingisdocumenting.znai.parser.TestComponentsRegistry;
import org.testingisdocumenting.znai.parser.commonmark.MarkdownParser;
import znaishaded.org.junit.Test;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MarkdownGeneratorParserHandlerTest
implements GroovyObject {
    private static final MarkupParser parser;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    @Generated
    public MarkdownGeneratorParserHandlerTest() {
        MetaClass metaClass;
        CallSite[] callSiteArray = MarkdownGeneratorParserHandlerTest.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @Test
    public void should generate markdown for basic text() {
        CallSite[] callSiteArray = MarkdownGeneratorParserHandlerTest.$getCallSiteArray();
        Object result = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            result = object = callSiteArray[0].callStatic(MarkdownGeneratorParserHandlerTest.class, (Object)"Hello world");
        } else {
            String string = MarkdownGeneratorParserHandlerTest.process("Hello world");
            result = string;
        }
        callSiteArray[1].call(result, callSiteArray[2].callStatic(WebTauCore.class, (Object)"Hello world\n\n"));
    }

    @Test
    public void should generate markdown with text formatting() {
        CallSite[] callSiteArray = MarkdownGeneratorParserHandlerTest.$getCallSiteArray();
        Object result = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            result = object = callSiteArray[3].callStatic(MarkdownGeneratorParserHandlerTest.class, (Object)"This is **bold** and *italic* and ~~strikethrough~~");
        } else {
            String string = MarkdownGeneratorParserHandlerTest.process("This is **bold** and *italic* and ~~strikethrough~~");
            result = string;
        }
        callSiteArray[4].call(result, callSiteArray[5].callStatic(WebTauCore.class, (Object)"This is **bold** and *italic* and ~~strikethrough~~\n\n"));
    }

    @Test
    public void should generate headers with base level adjustment() {
        CallSite[] callSiteArray = MarkdownGeneratorParserHandlerTest.$getCallSiteArray();
        Object result = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            result = object = callSiteArray[6].callStatic(MarkdownGeneratorParserHandlerTest.class, (Object)"# Header");
        } else {
            String string = MarkdownGeneratorParserHandlerTest.process("# Header");
            result = string;
        }
        callSiteArray[7].call(result, callSiteArray[8].callStatic(WebTauCore.class, (Object)"# Header\n\n"));
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            result = object = callSiteArray[9].callStatic(MarkdownGeneratorParserHandlerTest.class, (Object)"# Header", (Object)2);
        } else {
            String string = MarkdownGeneratorParserHandlerTest.process("# Header", 2);
            result = string;
        }
        callSiteArray[10].call(result, callSiteArray[11].callStatic(WebTauCore.class, (Object)"### Header\n\n"));
    }

    @Test
    public void should generate inline code() {
        CallSite[] callSiteArray = MarkdownGeneratorParserHandlerTest.$getCallSiteArray();
        Object result = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            result = object = callSiteArray[12].callStatic(MarkdownGeneratorParserHandlerTest.class, (Object)"Code: `hello()`");
        } else {
            String string = MarkdownGeneratorParserHandlerTest.process("Code: `hello()`");
            result = string;
        }
        callSiteArray[13].call(result, callSiteArray[14].callStatic(WebTauCore.class, (Object)"Code: `hello()`\n\n"));
    }

    @Test
    public void should generate code blocks() {
        CallSite[] callSiteArray = MarkdownGeneratorParserHandlerTest.$getCallSiteArray();
        Object result = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            result = object = callSiteArray[15].callStatic(MarkdownGeneratorParserHandlerTest.class, (Object)"```java\nSystem.out.println();\n```");
        } else {
            String string = MarkdownGeneratorParserHandlerTest.process("```java\nSystem.out.println();\n```");
            result = string;
        }
        callSiteArray[16].call(result, callSiteArray[17].callStatic(WebTauCore.class, (Object)"```java\nSystem.out.println();\n```\n\n"));
    }

    @Test
    public void should generate lists() {
        CallSite[] callSiteArray = MarkdownGeneratorParserHandlerTest.$getCallSiteArray();
        Object result = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            result = object = callSiteArray[18].callStatic(MarkdownGeneratorParserHandlerTest.class, (Object)"- Item one\n- Item two");
        } else {
            String string = MarkdownGeneratorParserHandlerTest.process("- Item one\n- Item two");
            result = string;
        }
        callSiteArray[19].call(result, callSiteArray[20].callStatic(WebTauCore.class, (Object)"- Item one\n- Item two\n\n"));
    }

    @Test
    public void should generate block quotes() {
        CallSite[] callSiteArray = MarkdownGeneratorParserHandlerTest.$getCallSiteArray();
        Object result = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            result = object = callSiteArray[21].callStatic(MarkdownGeneratorParserHandlerTest.class, (Object)"> Quote");
        } else {
            String string = MarkdownGeneratorParserHandlerTest.process("> Quote");
            result = string;
        }
        callSiteArray[22].call(result, callSiteArray[23].callStatic(WebTauCore.class, (Object)"> Quote\n\n"));
    }

    @Test
    public void should generate thematic breaks() {
        CallSite[] callSiteArray = MarkdownGeneratorParserHandlerTest.$getCallSiteArray();
        Object result = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            result = object = callSiteArray[24].callStatic(MarkdownGeneratorParserHandlerTest.class, (Object)"Text\n\n---\n\nMore text");
        } else {
            String string = MarkdownGeneratorParserHandlerTest.process("Text\n\n---\n\nMore text");
            result = string;
        }
        callSiteArray[25].call(result, callSiteArray[26].callStatic(WebTauCore.class, (Object)"Text\n\n---\n\nMore text\n\n"));
    }

    @Test
    public void should handle multi-paragraph content() {
        CallSite[] callSiteArray = MarkdownGeneratorParserHandlerTest.$getCallSiteArray();
        Object result = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            result = object = callSiteArray[27].callStatic(MarkdownGeneratorParserHandlerTest.class, (Object)"First paragraph\n\nSecond paragraph");
        } else {
            String string = MarkdownGeneratorParserHandlerTest.process("First paragraph\n\nSecond paragraph");
            result = string;
        }
        callSiteArray[28].call(result, callSiteArray[29].callStatic(WebTauCore.class, (Object)"First paragraph\n\nSecond paragraph\n\n"));
    }

    @Test
    public void should handle complex document with proper header level shifting() {
        CallSite[] callSiteArray = MarkdownGeneratorParserHandlerTest.$getCallSiteArray();
        Object result = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            result = object = callSiteArray[30].callStatic(MarkdownGeneratorParserHandlerTest.class, (Object)"# Main Title\n\nContent here\n\n## Subtitle\n\nMore content with **bold**", (Object)1);
        } else {
            String string = MarkdownGeneratorParserHandlerTest.process("# Main Title\n\nContent here\n\n## Subtitle\n\nMore content with **bold**", 1);
            result = string;
        }
        callSiteArray[31].call(result, callSiteArray[32].callStatic(WebTauCore.class, (Object)"## Main Title\n\nContent here\n\n### Subtitle\n\nMore content with **bold**\n\n"));
    }

    @Test
    public void should preserve markdown formatting in complex content() {
        CallSite[] callSiteArray = MarkdownGeneratorParserHandlerTest.$getCallSiteArray();
        Object result = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            result = object = callSiteArray[33].callStatic(MarkdownGeneratorParserHandlerTest.class, (Object)"# Documentation\n\nThis has **bold**, *italic*, and `code`.\n\n```python\nprint('hello')\n```\n\n- List item\n- Another item");
        } else {
            String string = MarkdownGeneratorParserHandlerTest.process("# Documentation\n\nThis has **bold**, *italic*, and `code`.\n\n```python\nprint('hello')\n```\n\n- List item\n- Another item");
            result = string;
        }
        callSiteArray[34].call(result, callSiteArray[35].callStatic(WebTauCore.class, callSiteArray[36].call(callSiteArray[37].call(callSiteArray[38].call(callSiteArray[39].call(callSiteArray[40].call(callSiteArray[41].call(callSiteArray[42].call(callSiteArray[43].call(callSiteArray[44].call((Object)"# Documentation\n", (Object)"\n"), (Object)"This has **bold**, *italic*, and `code`.\n"), (Object)"\n"), (Object)"```python\n"), (Object)"print('hello')\n"), (Object)"```\n"), (Object)"\n"), (Object)"- List item\n"), (Object)"- Another item\n\n")));
    }

    @Test
    public void should handle empty input() {
        CallSite[] callSiteArray = MarkdownGeneratorParserHandlerTest.$getCallSiteArray();
        Object result = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            result = object = callSiteArray[45].callStatic(MarkdownGeneratorParserHandlerTest.class, (Object)"");
        } else {
            String string = MarkdownGeneratorParserHandlerTest.process("");
            result = string;
        }
        callSiteArray[46].call(result, callSiteArray[47].callStatic(WebTauCore.class, (Object)""));
    }

    @Test
    public void should use plugin markdownRepresentation method for include plugins() {
        CallSite[] callSiteArray = MarkdownGeneratorParserHandlerTest.$getCallSiteArray();
        Object handler = callSiteArray[48].callConstructor(MarkdownGeneratorParserHandler.class, (Object)0);
        Object plugin = callSiteArray[49].callConstructor(DummyIncludePlugin.class);
        callSiteArray[50].call(plugin, callSiteArray[51].callGetProperty(TestComponentsRegistry.class), handler, callSiteArray[52].call(Paths.class, (Object)"test.md"), callSiteArray[53].call(callSiteArray[54].call(callSiteArray[55].callGetProperty(TestComponentsRegistry.class)), (Object)"dummy", (Object)"test-param", (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0])));
        callSiteArray[56].call(handler, plugin, callSiteArray[57].call(PluginResult.class));
        Object result = callSiteArray[58].call(handler);
        callSiteArray[59].call(result, callSiteArray[60].callStatic(WebTauCore.class, (Object)"**Dummy plugin content**: test-param\n\n"));
    }

    private static String process(String markdown, int baseHeadingLevel) {
        CallSite[] callSiteArray = MarkdownGeneratorParserHandlerTest.$getCallSiteArray();
        Object handler = callSiteArray[61].callConstructor(MarkdownGeneratorParserHandler.class, (Object)baseHeadingLevel);
        callSiteArray[62].call((Object)parser, callSiteArray[63].call(Paths.class, (Object)"test.md"), handler, (Object)markdown);
        return ShortTypeHandling.castToString((Object)callSiteArray[64].call(handler));
    }

    @Generated
    private static String process(String markdown) {
        CallSite[] callSiteArray = MarkdownGeneratorParserHandlerTest.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return MarkdownGeneratorParserHandlerTest.process(markdown, 0);
        }
        return MarkdownGeneratorParserHandlerTest.process(markdown, 0);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != MarkdownGeneratorParserHandlerTest.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        Object object = MarkdownGeneratorParserHandlerTest.$getCallSiteArray()[65].callConstructor(MarkdownParser.class, MarkdownGeneratorParserHandlerTest.$getCallSiteArray()[66].callGetProperty(TestComponentsRegistry.class));
        parser = (MarkupParser)ScriptBytecodeAdapter.castToType((Object)object, MarkupParser.class);
    }

    @Generated
    public static MarkupParser getParser() {
        return parser;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "process";
        stringArray[1] = "should";
        stringArray[2] = "equal";
        stringArray[3] = "process";
        stringArray[4] = "should";
        stringArray[5] = "equal";
        stringArray[6] = "process";
        stringArray[7] = "should";
        stringArray[8] = "equal";
        stringArray[9] = "process";
        stringArray[10] = "should";
        stringArray[11] = "equal";
        stringArray[12] = "process";
        stringArray[13] = "should";
        stringArray[14] = "equal";
        stringArray[15] = "process";
        stringArray[16] = "should";
        stringArray[17] = "equal";
        stringArray[18] = "process";
        stringArray[19] = "should";
        stringArray[20] = "equal";
        stringArray[21] = "process";
        stringArray[22] = "should";
        stringArray[23] = "equal";
        stringArray[24] = "process";
        stringArray[25] = "should";
        stringArray[26] = "equal";
        stringArray[27] = "process";
        stringArray[28] = "should";
        stringArray[29] = "equal";
        stringArray[30] = "process";
        stringArray[31] = "should";
        stringArray[32] = "equal";
        stringArray[33] = "process";
        stringArray[34] = "should";
        stringArray[35] = "equal";
        stringArray[36] = "plus";
        stringArray[37] = "plus";
        stringArray[38] = "plus";
        stringArray[39] = "plus";
        stringArray[40] = "plus";
        stringArray[41] = "plus";
        stringArray[42] = "plus";
        stringArray[43] = "plus";
        stringArray[44] = "plus";
        stringArray[45] = "process";
        stringArray[46] = "should";
        stringArray[47] = "equal";
        stringArray[48] = "<$constructor$>";
        stringArray[49] = "<$constructor$>";
        stringArray[50] = "process";
        stringArray[51] = "TEST_COMPONENTS_REGISTRY";
        stringArray[52] = "get";
        stringArray[53] = "create";
        stringArray[54] = "pluginParamsFactory";
        stringArray[55] = "TEST_COMPONENTS_REGISTRY";
        stringArray[56] = "onIncludePlugin";
        stringArray[57] = "empty";
        stringArray[58] = "getMarkdown";
        stringArray[59] = "should";
        stringArray[60] = "equal";
        stringArray[61] = "<$constructor$>";
        stringArray[62] = "parse";
        stringArray[63] = "get";
        stringArray[64] = "getMarkdown";
        stringArray[65] = "<$constructor$>";
        stringArray[66] = "TEST_COMPONENTS_REGISTRY";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[67];
        MarkdownGeneratorParserHandlerTest.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(MarkdownGeneratorParserHandlerTest.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = MarkdownGeneratorParserHandlerTest.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

