/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.parser.commonmark;

import java.util.Collections;
import java.util.Map;
import org.testingisdocumenting.znai.parser.HeadingProps;
import org.testingisdocumenting.znai.utils.JsonParseException;
import org.testingisdocumenting.znai.utils.JsonUtils;

public record HeadingTextAndProps(String text, HeadingProps props) {
    public static HeadingTextAndProps extractTextAndProps(String text) {
        int startOfCurlyIdx = text.indexOf(123);
        int endOfCurlyIdx = text.lastIndexOf(125);
        if (startOfCurlyIdx == -1 || endOfCurlyIdx == -1) {
            return new HeadingTextAndProps(text, HeadingProps.EMPTY);
        }
        String json = text.substring(startOfCurlyIdx);
        if (json.length() < 3) {
            return new HeadingTextAndProps(text, HeadingProps.EMPTY);
        }
        Map<String, ?> props = json.charAt(1) == '#' ? HeadingTextAndProps.parseCustomAnchorId(json) : HeadingTextAndProps.parseJson(json);
        String headingTextOnly = text.substring(0, startOfCurlyIdx);
        return new HeadingTextAndProps(headingTextOnly, new HeadingProps(props));
    }

    private static Map<String, ?> parseCustomAnchorId(String anchorExpression) {
        int endOfCurlyIdx = anchorExpression.lastIndexOf(125);
        String anchorId = anchorExpression.substring(2, endOfCurlyIdx);
        return Collections.singletonMap("customAnchorId", anchorId);
    }

    private static Map<String, ?> parseJson(String json) {
        try {
            return JsonUtils.deserializeAsMap(json);
        }
        catch (JsonParseException e) {
            throw new RuntimeException("Can't parse props of heading: " + json, e);
        }
    }
}

