/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.python;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.extensions.api.ApiLinkedText;
import org.testingisdocumenting.znai.extensions.api.ApiParameters;
import org.testingisdocumenting.znai.parser.HeadingProps;
import org.testingisdocumenting.znai.parser.ParserHandler;
import org.testingisdocumenting.znai.python.PythonClass;
import org.testingisdocumenting.znai.python.PythonIncludeResult;
import org.testingisdocumenting.znai.python.PythonParsedEntry;
import org.testingisdocumenting.znai.python.PythonUtils;
import org.testingisdocumenting.znai.python.pydoc.ParsedPythonDoc;

class PythonIncludeResultBuilder {
    private static final HeadingProps entryNameHeadingProps = HeadingProps.STYLE_API;
    private final List<String> searchText;
    private final ComponentsRegistry componentsRegistry;
    private final ParserHandler parserHandler;
    private final Path markupPath;
    private final String qualifiedName;

    public PythonIncludeResultBuilder(ComponentsRegistry componentsRegistry, ParserHandler parserHandler, Path markupPath, String qualifiedName) {
        this.componentsRegistry = componentsRegistry;
        this.parserHandler = parserHandler;
        this.markupPath = markupPath;
        this.qualifiedName = qualifiedName;
        this.searchText = new ArrayList<String>();
    }

    public PythonIncludeResult build() {
        return new PythonIncludeResult(Collections.emptyList(), String.join((CharSequence)" ", this.searchText));
    }

    public void addClassHeader() {
        String globalAnchorId = PythonUtils.globalAnchorId(this.qualifiedName);
        this.parserHandler.onGlobalAnchor(globalAnchorId);
        this.parserHandler.onSectionStart(this.qualifiedName, HeadingProps.styleApiWithBadge("class"), null);
    }

    public void addSubSection(String title) {
        this.parserHandler.onSubHeading(3, title, entryNameHeadingProps, null);
    }

    public void addEntryHeader(String name) {
        this.parserHandler.onSubHeading(4, name, entryNameHeadingProps, null);
    }

    public void addMethodSignature(String packageName, PythonParsedEntry func, NameRenderOpt nameRenderOpt, ArgsRenderOpt argsRenderOpt, MarginOpts marginOpts, boolean attachUrl) {
        LinkedHashMap props = new LinkedHashMap(func.toMap(this.componentsRegistry.docStructure()));
        props.put("qualifiedName", packageName + "." + func.getName());
        if (nameRenderOpt == NameRenderOpt.SHORT_NAME) {
            props.put("hideNameQualifier", true);
        }
        if (argsRenderOpt == ArgsRenderOpt.REMOVE_SELF) {
            props.put("removeSelf", true);
        }
        if (marginOpts == MarginOpts.EXTRA_BOTTOM_MARGIN) {
            props.put("extraBottomMargin", true);
        }
        if (attachUrl) {
            Supplier<String> urlSupplier = () -> {
                Optional<String> globalAnchorUrl = this.componentsRegistry.docStructure().findGlobalAnchorUrl(PythonUtils.globalAnchorId(packageName + "." + func.getName()));
                return globalAnchorUrl.orElse("");
            };
            props.put("url", urlSupplier);
        }
        this.parserHandler.onCustomNode("PythonMethod", props);
        this.searchText.add(func.getName());
    }

    public void addPyDocTextOnly(PythonParsedEntry codeEntry) {
        ParsedPythonDoc parsedPythonDoc = new ParsedPythonDoc(codeEntry.getDocString());
        this.componentsRegistry.markdownParser().parse(this.markupPath, parsedPythonDoc.getPyDocDescriptionOnly()).docElement().getContent().forEach(this.parserHandler::onDocElement);
        this.searchText.add(parsedPythonDoc.getPyDocDescriptionOnly());
    }

    public void addPyDocParams(String packageName, PythonParsedEntry func) {
        ApiParameters apiParameters = func.createParametersFromPyDoc(this.componentsRegistry.docStructure(), this.componentsRegistry.markdownParser(), this.markupPath, packageName + "_" + func.getName());
        if (apiParameters.isEmpty()) {
            return;
        }
        Map<String, Object> props = apiParameters.toMap();
        props.put("small", true);
        this.parserHandler.onCustomNode("ApiParameters", props);
        this.searchText.add(apiParameters.combinedTextForSearch());
    }

    public void addBaseClassesLinks(List<PythonClass> baseClasses) {
        if (baseClasses.isEmpty()) {
            return;
        }
        this.parserHandler.onParagraphStart();
        this.parserHandler.onStrongEmphasisStart();
        this.parserHandler.onSimpleText("Base classes: ");
        this.parserHandler.onStrongEmphasisEnd();
        int baseClassIdx = 0;
        for (PythonClass baseClass : baseClasses) {
            boolean isLastClass;
            ApiLinkedText linkedText = new ApiLinkedText();
            String fullName = baseClass.buildFullName();
            String globalAnchorId = PythonUtils.globalAnchorId(fullName);
            linkedText.addPart(fullName, () -> {
                Optional<String> anchorUrl = this.componentsRegistry.docStructure().findGlobalAnchorUrl(globalAnchorId);
                return anchorUrl.orElse("");
            });
            this.parserHandler.onCustomNode("ApiLinkedTextBlock", Collections.singletonMap("linkedText", linkedText.toListOfMaps()));
            boolean bl = isLastClass = baseClassIdx == baseClasses.size() - 1;
            if (!isLastClass) {
                this.parserHandler.onSimpleText(", ");
            }
            ++baseClassIdx;
        }
        this.parserHandler.onParagraphEnd();
        baseClasses.forEach(bc -> this.searchText.add(bc.getName()));
    }

    public void addSearchText(String text) {
        this.searchText.add(text);
    }

    static enum NameRenderOpt {
        FULL_NAME,
        SHORT_NAME;

    }

    static enum ArgsRenderOpt {
        REMOVE_SELF,
        KEEP_SELF;

    }

    static enum MarginOpts {
        EXTRA_BOTTOM_MARGIN,
        DEFAULT;

    }
}

