/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.server.preview;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Path;
import java.util.Set;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.console.ConsoleOutputs;
import org.testingisdocumenting.znai.console.ansi.Color;
import org.testingisdocumenting.znai.core.DocMeta;
import org.testingisdocumenting.znai.html.DocPageReactProps;
import org.testingisdocumenting.znai.html.HtmlPageAndPageProps;
import org.testingisdocumenting.znai.reference.DocReferences;
import org.testingisdocumenting.znai.server.preview.FileChangeHandler;
import org.testingisdocumenting.znai.server.preview.PreviewSendChangesWebSocketHandler;
import org.testingisdocumenting.znai.structure.Footer;
import org.testingisdocumenting.znai.structure.TocItem;
import org.testingisdocumenting.znai.utils.FileUtils;
import org.testingisdocumenting.znai.website.TocAddedUpdatedAndRemovedPages;
import org.testingisdocumenting.znai.website.WebSite;

public class PreviewPushFileChangeHandler
implements FileChangeHandler {
    private final PreviewSendChangesWebSocketHandler previewSocket;
    private final WebSite previewWebSite;

    public PreviewPushFileChangeHandler(PreviewSendChangesWebSocketHandler previewSocket, WebSite previewWebSite) {
        this.previewSocket = previewSocket;
        this.previewWebSite = previewWebSite;
    }

    @Override
    public void onTocChange(Path tocPath) {
        ConsoleOutputs.out("toc changed: ", tocPath);
        this.execute(() -> {
            TocAddedUpdatedAndRemovedPages tocAddedUpdatedAndRemovedPages = this.previewWebSite.updateToc();
            this.previewSocket.sendToc(tocAddedUpdatedAndRemovedPages.tableOfContents());
            if (!tocAddedUpdatedAndRemovedPages.addedOrUpdatedPagesProps().isEmpty()) {
                this.previewSocket.sendPages(tocAddedUpdatedAndRemovedPages.addedOrUpdatedPagesProps().stream().map(HtmlPageAndPageProps::props));
            }
            if (!tocAddedUpdatedAndRemovedPages.removedTocItems().isEmpty()) {
                this.previewSocket.sendPagesRemove(tocAddedUpdatedAndRemovedPages.removedTocItems().stream());
            }
        });
    }

    @Override
    public void onFooterChange(Path tocPath) {
        ConsoleOutputs.out("footer changed: ", tocPath);
        this.execute(() -> {
            Footer footer = this.previewWebSite.updateFooter();
            this.previewSocket.sendFooter(footer);
        });
    }

    @Override
    public void onGlobalDocReferencesChange(Path docReferencePath) {
        ConsoleOutputs.out("global doc references changed: ", docReferencePath);
        this.execute(() -> {
            DocReferences docReferences = this.previewWebSite.updateDocReferences();
            this.previewSocket.sendDocReferences(docReferences);
        });
    }

    @Override
    public void onDocMetaChange(Path metaPath) {
        ConsoleOutputs.out("meta changed: ", metaPath);
        this.execute(() -> {
            String metaJson = FileUtils.fileTextContent(metaPath);
            DocMeta newDocMeta = this.previewWebSite.getDocMeta().cloneWithNewJson(metaJson);
            this.previewSocket.sendMeta(newDocMeta);
        });
    }

    private HtmlPageAndPageProps regenerate(Path markupPath) {
        TocItem tocItem = this.previewWebSite.tocItemByPath(markupPath);
        if (tocItem == null) {
            return null;
        }
        return this.previewWebSite.regenerateAndValidatePageDeployTocAndAllPages(tocItem);
    }

    @Override
    public void onChange(Path path) {
        ConsoleOutputs.out("file changed: ", path);
        TocItem tocItem = this.previewWebSite.tocItemByPath(path);
        if (tocItem == null) {
            ConsoleOutputs.out(String.valueOf(path) + " is not part of table of contents, checking dependent files");
            this.onDependentChange(path);
        } else {
            this.onMarkupChange(path);
        }
    }

    private void onMarkupChange(Path path) {
        this.execute(() -> {
            HtmlPageAndPageProps htmlPageAndPageProps = this.regenerate(path);
            if (htmlPageAndPageProps == null) {
                return;
            }
            this.previewSocket.sendPage(htmlPageAndPageProps.props());
            this.previewSocket.sendToc(this.previewWebSite.getToc());
        });
    }

    private void onDependentChange(Path path) {
        this.execute(() -> {
            Set<TocItem> dependentTocItems = this.previewWebSite.dependentTocItems(path);
            if (dependentTocItems.isEmpty()) {
                ConsoleOutputs.out(new Object[]{"no markup files depends on ", Color.BLUE, path});
                return;
            }
            this.previewWebSite.redeployAuxiliaryFileIfRequired(path);
            dependentTocItems.forEach(System.out::println);
            Stream<DocPageReactProps> generatedPages = dependentTocItems.stream().map(tocItem -> this.previewWebSite.regenerateAndValidatePageDeployTocAndAllPages((TocItem)tocItem).props());
            this.previewSocket.sendPages(generatedPages);
            this.previewSocket.sendToc(this.previewWebSite.getToc());
        });
    }

    private void execute(Runnable code) {
        try {
            code.run();
        }
        catch (Exception e) {
            ConsoleOutputs.err(e.getMessage());
            this.previewSocket.sendError(e.getMessage(), PreviewPushFileChangeHandler.renderStackTrace(e));
        }
    }

    private static String renderStackTrace(Throwable t) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        t.printStackTrace(writer);
        return stringWriter.toString();
    }
}

