/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.structure;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.testingisdocumenting.znai.core.MarkupPathWithError;
import org.testingisdocumenting.znai.structure.TocItem;
import org.testingisdocumenting.znai.structure.TocNameAndOpts;

public class TableOfContents {
    private final String defaultFileExtension;
    private final List<TocItem> tocItems;
    private final Map<Path, TocItem> tocItemByPath;

    public TableOfContents(String defaultFileExtension) {
        this.defaultFileExtension = defaultFileExtension;
        this.tocItems = new ArrayList<TocItem>();
        this.tocItemByPath = new LinkedHashMap<Path, TocItem>();
    }

    public TocItem addTocItem(TocNameAndOpts chapter, TocNameAndOpts page) {
        TocItem tocItem = new TocItem(chapter, page, this.defaultFileExtension);
        this.tocItems.add(tocItem);
        return tocItem;
    }

    public TocItem addTocItem(String dirName, String fileNameWithOptionalExtension) {
        TocItem tocItem = new TocItem(dirName, fileNameWithOptionalExtension, this.defaultFileExtension);
        this.tocItems.add(tocItem);
        return tocItem;
    }

    public List<TocItem> resolveTocItemPathsAndReturnMissing(Function<TocItem, MarkupPathWithError> filePathResolver) {
        this.tocItemByPath.clear();
        ArrayList<TocItem> missing = new ArrayList<TocItem>();
        for (TocItem tocItem : this.tocItems) {
            if (tocItem.isIndex()) continue;
            MarkupPathWithError pathWithError = filePathResolver.apply(tocItem);
            if (pathWithError.error() != null) {
                missing.add(tocItem);
                continue;
            }
            this.tocItemByPath.put(pathWithError.path(), tocItem);
        }
        return missing;
    }

    public void addIndex() {
        this.tocItems.add(0, TocItem.createIndex());
    }

    public TocItem firstNonIndexPage() {
        return this.tocItems.stream().filter(tocItem -> !tocItem.isIndex()).findFirst().orElse(null);
    }

    public Optional<TocItem> firstPageInChapter(String dirName) {
        return this.tocItems.stream().filter(tocItem -> tocItem.getDirName().equals(dirName)).findFirst();
    }

    public void removeTocItem(String dirName, String fileNameWithoutExtension) {
        this.tocItems.removeIf(item -> item.match(dirName, fileNameWithoutExtension));
    }

    public void replaceTocItem(String originalDirName, String originalFileNameWithoutExtension, TocNameAndOpts newChapter, TocNameAndOpts newPage) {
        int idx = this.findTocItemIdx(originalDirName, originalFileNameWithoutExtension);
        if (idx == -1) {
            throw new IllegalArgumentException("can't find toc item: " + originalDirName + "/" + originalFileNameWithoutExtension);
        }
        this.tocItems.set(idx, new TocItem(newChapter, newPage, this.defaultFileExtension));
    }

    public List<TocItem> detectNewTocItems(TableOfContents newToc) {
        LinkedHashSet<TocItem> existingItems = new LinkedHashSet<TocItem>(this.tocItems);
        LinkedHashSet<TocItem> newItems = new LinkedHashSet<TocItem>(newToc.tocItems);
        newItems.removeAll(existingItems);
        return new ArrayList<TocItem>(newItems);
    }

    public List<TocItem> detectRemovedTocItems(TableOfContents newToc) {
        LinkedHashSet<TocItem> existingItems = new LinkedHashSet<TocItem>(this.tocItems);
        LinkedHashSet<TocItem> newItems = new LinkedHashSet<TocItem>(newToc.tocItems);
        existingItems.removeAll(newItems);
        return new ArrayList<TocItem>(existingItems);
    }

    public List<TocItem> detectChangedTocItems(TableOfContents newToc) {
        ArrayList<TocItem> result = new ArrayList<TocItem>();
        for (TocItem tocItem : newToc.tocItems) {
            TocItem existingTocItem = this.findTocItem(tocItem.getDirName(), tocItem.getFileNameWithoutExtension());
            if (existingTocItem == null || !this.areTocItemsDifferent(existingTocItem, tocItem)) continue;
            result.add(tocItem);
        }
        return result;
    }

    public TocItem getIndex() {
        if (this.tocItems.isEmpty()) {
            return null;
        }
        TocItem first = this.tocItems.get(0);
        return first.isIndex() ? first : null;
    }

    public List<TocItem> getTocItems() {
        return Collections.unmodifiableList(this.tocItems);
    }

    public Set<String> getAllDirNames() {
        return this.tocItems.stream().map(TocItem::getDirName).filter(dirName -> !dirName.isEmpty()).collect(Collectors.toSet());
    }

    public Collection<Path> getResolvedPaths() {
        return this.tocItemByPath.keySet();
    }

    public boolean contains(String dirName, String fileName, String pageSectionId) {
        TocItem tocItem = this.findTocItem(dirName, fileName);
        return tocItem != null && (pageSectionId.isEmpty() || tocItem.hasPageSection(pageSectionId));
    }

    public TocItem findTocItem(String dirName, String fileNameWithoutExtension) {
        int idx = this.findTocItemIdx(dirName, fileNameWithoutExtension);
        return idx == -1 ? null : this.tocItems.get(idx);
    }

    public TocItem findTocItem(Path markupFilePath) {
        return this.tocItemByPath.get(markupFilePath);
    }

    public List<Map<String, Object>> toListOfMaps() {
        Map bySectionTitle = this.tocItems.stream().collect(Collectors.groupingBy(TocItem::getChapterTitle, LinkedHashMap::new, Collectors.toList()));
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        bySectionTitle.forEach((sectionTitle, items) -> result.add(this.createChapterWithItems((String)sectionTitle, (List<TocItem>)items)));
        return result;
    }

    public String toString() {
        return this.tocItems.stream().map(TocItem::toString).collect(Collectors.joining("\n"));
    }

    private int findTocItemIdx(String dirName, String fileNameWithoutExtension) {
        for (int idx = 0; idx < this.tocItems.size(); ++idx) {
            if (!this.tocItems.get(idx).match(dirName, fileNameWithoutExtension)) continue;
            return idx;
        }
        return -1;
    }

    private Map<String, Object> createChapterWithItems(String sectionTitle, List<TocItem> items) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if (items.isEmpty()) {
            return result;
        }
        result.put("chapterTitle", sectionTitle);
        result.put("dirName", items.iterator().next().getDirName());
        result.put("items", items.stream().map(TocItem::toMap).collect(Collectors.toList()));
        return result;
    }

    private boolean areTocItemsDifferent(TocItem a, TocItem b) {
        return !a.getChapterTitle().equals(b.getChapterTitle()) || !a.getPageTitle().equals(b.getPageTitle());
    }
}

