/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.com.github.fge.jsonschema.main;

import java.util.Map;
import javax.annotation.concurrent.Immutable;
import znaishaded.com.fasterxml.jackson.databind.JsonNode;
import znaishaded.com.github.fge.Frozen;
import znaishaded.com.github.fge.jackson.jsonpointer.JsonPointer;
import znaishaded.com.github.fge.jackson.jsonpointer.JsonPointerException;
import znaishaded.com.github.fge.jsonschema.cfg.ValidationConfiguration;
import znaishaded.com.github.fge.jsonschema.core.exceptions.ProcessingException;
import znaishaded.com.github.fge.jsonschema.core.load.RefResolver;
import znaishaded.com.github.fge.jsonschema.core.load.SchemaLoader;
import znaishaded.com.github.fge.jsonschema.core.load.configuration.LoadingConfiguration;
import znaishaded.com.github.fge.jsonschema.core.messages.JsonSchemaCoreMessageBundle;
import znaishaded.com.github.fge.jsonschema.core.processing.CachingProcessor;
import znaishaded.com.github.fge.jsonschema.core.processing.Processor;
import znaishaded.com.github.fge.jsonschema.core.processing.ProcessorMap;
import znaishaded.com.github.fge.jsonschema.core.ref.JsonRef;
import znaishaded.com.github.fge.jsonschema.core.report.ReportProvider;
import znaishaded.com.github.fge.jsonschema.library.Library;
import znaishaded.com.github.fge.jsonschema.main.JsonSchema;
import znaishaded.com.github.fge.jsonschema.main.JsonSchemaFactoryBuilder;
import znaishaded.com.github.fge.jsonschema.main.JsonValidator;
import znaishaded.com.github.fge.jsonschema.messages.JsonSchemaConfigurationBundle;
import znaishaded.com.github.fge.jsonschema.processors.data.FullData;
import znaishaded.com.github.fge.jsonschema.processors.data.SchemaContext;
import znaishaded.com.github.fge.jsonschema.processors.data.ValidatorList;
import znaishaded.com.github.fge.jsonschema.processors.syntax.SyntaxValidator;
import znaishaded.com.github.fge.jsonschema.processors.validation.SchemaContextEquivalence;
import znaishaded.com.github.fge.jsonschema.processors.validation.ValidationChain;
import znaishaded.com.github.fge.jsonschema.processors.validation.ValidationProcessor;
import znaishaded.com.github.fge.msgsimple.bundle.MessageBundle;
import znaishaded.com.github.fge.msgsimple.load.MessageBundles;
import znaishaded.com.google.common.base.Function;

@Immutable
public final class JsonSchemaFactory
implements Frozen<JsonSchemaFactoryBuilder> {
    private static final MessageBundle BUNDLE = MessageBundles.getBundle(JsonSchemaConfigurationBundle.class);
    private static final MessageBundle CORE_BUNDLE = MessageBundles.getBundle(JsonSchemaCoreMessageBundle.class);
    private static final Function<SchemaContext, JsonRef> FUNCTION = new Function<SchemaContext, JsonRef>(){

        @Override
        public JsonRef apply(SchemaContext input) {
            return input.getSchema().getDollarSchema();
        }
    };
    final ReportProvider reportProvider;
    final LoadingConfiguration loadingCfg;
    final ValidationConfiguration validationCfg;
    private final SchemaLoader loader;
    private final JsonValidator validator;
    private final SyntaxValidator syntaxValidator;

    public static JsonSchemaFactory byDefault() {
        return JsonSchemaFactory.newBuilder().freeze();
    }

    public static JsonSchemaFactoryBuilder newBuilder() {
        return new JsonSchemaFactoryBuilder();
    }

    JsonSchemaFactory(JsonSchemaFactoryBuilder builder) {
        this.reportProvider = builder.reportProvider;
        this.loadingCfg = builder.loadingCfg;
        this.validationCfg = builder.validationCfg;
        this.loader = new SchemaLoader(this.loadingCfg);
        Processor<SchemaContext, ValidatorList> processor = this.buildProcessor();
        this.validator = new JsonValidator(this.loader, new ValidationProcessor(this.validationCfg, processor), this.reportProvider);
        this.syntaxValidator = new SyntaxValidator(this.validationCfg);
    }

    public JsonValidator getValidator() {
        return this.validator;
    }

    public SyntaxValidator getSyntaxValidator() {
        return this.syntaxValidator;
    }

    public JsonSchema getJsonSchema(JsonNode schema) throws ProcessingException {
        BUNDLE.checkNotNull(schema, "nullSchema");
        return this.validator.buildJsonSchema(schema, JsonPointer.empty());
    }

    public JsonSchema getJsonSchema(JsonNode schema, String ptr) throws ProcessingException {
        BUNDLE.checkNotNull(schema, "nullSchema");
        CORE_BUNDLE.checkNotNull(ptr, "nullPointer");
        try {
            JsonPointer pointer = new JsonPointer(ptr);
            return this.validator.buildJsonSchema(schema, pointer);
        }
        catch (JsonPointerException jsonPointerException) {
            throw new IllegalStateException("How did I get there??");
        }
    }

    public JsonSchema getJsonSchema(String uri) throws ProcessingException {
        CORE_BUNDLE.checkNotNull(uri, "nullURI");
        return this.validator.buildJsonSchema(uri);
    }

    public Processor<FullData, FullData> getProcessor() {
        return this.validator.getProcessor();
    }

    @Override
    public JsonSchemaFactoryBuilder thaw() {
        return new JsonSchemaFactoryBuilder(this);
    }

    private Processor<SchemaContext, ValidatorList> buildProcessor() {
        RefResolver resolver = new RefResolver(this.loader);
        Map<JsonRef, Library> libraries = this.validationCfg.getLibraries();
        Library defaultLibrary = this.validationCfg.getDefaultLibrary();
        ValidationChain defaultChain = new ValidationChain(resolver, defaultLibrary, this.validationCfg);
        ProcessorMap<JsonRef, SchemaContext, ValidatorList> map = new ProcessorMap<JsonRef, SchemaContext, ValidatorList>(FUNCTION);
        map.setDefaultProcessor(defaultChain);
        for (Map.Entry<JsonRef, Library> entry : libraries.entrySet()) {
            JsonRef ref = entry.getKey();
            ValidationChain chain = new ValidationChain(resolver, entry.getValue(), this.validationCfg);
            map.addEntry(ref, chain);
        }
        Processor processor = map.getProcessor();
        return new CachingProcessor<SchemaContext, ValidatorList>(processor, SchemaContextEquivalence.getInstance(), this.validationCfg.getCacheSize());
    }
}

