/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.com.google.common.collect;

import znaishaded.com.google.common.annotations.GwtCompatible;
import znaishaded.com.google.common.annotations.GwtIncompatible;
import znaishaded.com.google.common.annotations.J2ktIncompatible;
import znaishaded.com.google.common.collect.AbstractMapBasedMultiset;
import znaishaded.com.google.common.collect.ElementTypesAreNonnullByDefault;
import znaishaded.com.google.common.collect.Iterables;
import znaishaded.com.google.common.collect.Multisets;
import znaishaded.com.google.common.collect.ObjectCountHashMap;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true, emulated=true)
public final class HashMultiset<E>
extends AbstractMapBasedMultiset<E> {
    @GwtIncompatible
    @J2ktIncompatible
    private static final long serialVersionUID = 0L;

    public static <E> HashMultiset<E> create() {
        return HashMultiset.create(3);
    }

    public static <E> HashMultiset<E> create(int distinctElements) {
        return new HashMultiset<E>(distinctElements);
    }

    public static <E> HashMultiset<E> create(Iterable<? extends E> elements) {
        HashMultiset<E> multiset = HashMultiset.create(Multisets.inferDistinctElements(elements));
        Iterables.addAll(multiset, elements);
        return multiset;
    }

    HashMultiset(int distinctElements) {
        super(distinctElements);
    }

    @Override
    ObjectCountHashMap<E> newBackingMap(int distinctElements) {
        return new ObjectCountHashMap(distinctElements);
    }
}

