/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.freemarker.core;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import znaishaded.freemarker.core.TemplateDateFormat;
import znaishaded.freemarker.core.TemplateFormatUtil;
import znaishaded.freemarker.core.UnparsableValueException;
import znaishaded.freemarker.template.TemplateDateModel;
import znaishaded.freemarker.template.TemplateModelException;

class JavaTemplateDateFormat
extends TemplateDateFormat {
    private final DateFormat javaDateFormat;

    public JavaTemplateDateFormat(DateFormat javaDateFormat) {
        this.javaDateFormat = javaDateFormat;
    }

    @Override
    public String formatToPlainText(TemplateDateModel dateModel) throws TemplateModelException {
        return this.javaDateFormat.format(TemplateFormatUtil.getNonNullDate(dateModel));
    }

    @Override
    public Date parse(String s2, int dateType) throws UnparsableValueException {
        try {
            return this.javaDateFormat.parse(s2);
        }
        catch (ParseException e) {
            throw new UnparsableValueException(e.getMessage(), e);
        }
    }

    @Override
    public String getDescription() {
        return this.javaDateFormat instanceof SimpleDateFormat ? ((SimpleDateFormat)this.javaDateFormat).toPattern() : this.javaDateFormat.toString();
    }

    @Override
    public boolean isLocaleBound() {
        return true;
    }

    @Override
    public boolean isTimeZoneBound() {
        return true;
    }
}

