/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.swagger.parser.processors;

import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import znaishaded.io.swagger.models.ArrayModel;
import znaishaded.io.swagger.models.ComposedModel;
import znaishaded.io.swagger.models.Model;
import znaishaded.io.swagger.models.ModelImpl;
import znaishaded.io.swagger.models.RefModel;
import znaishaded.io.swagger.models.RefResponse;
import znaishaded.io.swagger.models.Response;
import znaishaded.io.swagger.models.Swagger;
import znaishaded.io.swagger.models.properties.ArrayProperty;
import znaishaded.io.swagger.models.properties.ComposedProperty;
import znaishaded.io.swagger.models.properties.MapProperty;
import znaishaded.io.swagger.models.properties.ObjectProperty;
import znaishaded.io.swagger.models.properties.Property;
import znaishaded.io.swagger.models.properties.RefProperty;
import znaishaded.io.swagger.models.properties.StringProperty;
import znaishaded.io.swagger.models.refs.RefFormat;
import znaishaded.io.swagger.models.refs.RefType;
import znaishaded.io.swagger.parser.ResolverCache;
import znaishaded.io.swagger.parser.util.RefUtils;
import znaishaded.org.apache.commons.lang3.StringUtils;
import znaishaded.org.slf4j.Logger;
import znaishaded.org.slf4j.LoggerFactory;

public final class ExternalRefProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExternalRefProcessor.class);
    private final ResolverCache cache;
    private final Swagger swagger;

    public ExternalRefProcessor(ResolverCache cache, Swagger swagger) {
        this.cache = cache;
        this.swagger = swagger;
    }

    public String processRefToExternalDefinition(String $ref, RefFormat refFormat) {
        String renamedRef = this.cache.getRenamedRef($ref);
        if (renamedRef != null) {
            return renamedRef;
        }
        Model model = this.cache.loadRef($ref, refFormat, Model.class);
        if (model == null) {
            LOGGER.warn("unable to load model reference from `" + $ref + "`.  It may not be available or the reference isn't a valid model schema");
            return $ref;
        }
        Map<String, Model> definitions = this.swagger.getDefinitions();
        if (definitions == null) {
            definitions = new LinkedHashMap<String, Model>();
        }
        String possiblyConflictingDefinitionName = RefUtils.computeDefinitionName($ref);
        String tryName = null;
        Model existingModel = definitions.get(possiblyConflictingDefinitionName);
        if (existingModel != null) {
            LOGGER.debug("A model for " + existingModel + " already exists");
            if (existingModel instanceof RefModel) {
                existingModel = null;
            } else {
                int i = 2;
                for (String name : definitions.keySet()) {
                    if (!name.equals(possiblyConflictingDefinitionName)) continue;
                    tryName = possiblyConflictingDefinitionName + "_" + i;
                    existingModel = definitions.get(tryName);
                    ++i;
                }
            }
        }
        String newRef = StringUtils.isNotBlank(tryName) ? tryName : possiblyConflictingDefinitionName;
        this.cache.putRenamedRef($ref, newRef);
        if (existingModel == null) {
            this.swagger.addDefinition(newRef, model);
            this.cache.addReferencedKey(newRef);
            String file = $ref.split("#/")[0];
            if (model instanceof RefModel) {
                RefModel refModel = (RefModel)model;
                if (RefUtils.isAnExternalRefFormat(refModel.getRefFormat())) {
                    refModel.set$ref(this.processRefToExternalDefinition(refModel.get$ref(), refModel.getRefFormat()));
                } else {
                    refModel.set$ref(this.processRefToExternalDefinition(file + refModel.get$ref(), RefFormat.RELATIVE));
                }
            }
            if (model instanceof ComposedModel) {
                ComposedModel composedModel = (ComposedModel)model;
                List<Model> listOfAllOF = composedModel.getAllOf();
                for (Model allOfModel : listOfAllOF) {
                    if (allOfModel instanceof RefModel) {
                        RefModel refModel = (RefModel)allOfModel;
                        if (RefUtils.isAnExternalRefFormat(refModel.getRefFormat())) {
                            String joinedRef = ExternalRefProcessor.join(file, refModel.get$ref());
                            refModel.set$ref(this.processRefToExternalDefinition(joinedRef, refModel.getRefFormat()));
                            continue;
                        }
                        this.processRefToExternalDefinition(file + refModel.get$ref(), RefFormat.RELATIVE);
                        continue;
                    }
                    if (!(allOfModel instanceof ModelImpl)) continue;
                    this.processProperties(allOfModel.getProperties(), file);
                }
            }
            this.processProperties(model.getProperties(), file);
            if (model instanceof ModelImpl) {
                ModelImpl modelImpl = (ModelImpl)model;
                String discriminator = modelImpl.getDiscriminator();
                if (discriminator != null) {
                    this.processDiscriminator(discriminator, modelImpl.getProperties(), file);
                }
                this.processProperties(Arrays.asList(modelImpl.getAdditionalProperties()), file);
            }
            if (model instanceof ArrayModel && ((ArrayModel)model).getItems() instanceof RefProperty) {
                this.processRefProperty((RefProperty)((ArrayModel)model).getItems(), file);
            }
            if (model instanceof ArrayModel && ((ArrayModel)model).getItems() != null) {
                ArrayModel arraySchema = (ArrayModel)model;
                if (arraySchema.getItems() instanceof RefModel) {
                    this.processRefProperty((RefProperty)((ArrayModel)model).getItems(), file);
                } else {
                    Property properties = arraySchema.getItems();
                    if (properties instanceof ObjectProperty) {
                        this.processProperties(((ObjectProperty)properties).getProperties(), file);
                    }
                }
            }
        }
        return newRef;
    }

    public String processRefToExternalResponse(String $ref, RefFormat refFormat) {
        String possiblyConflictingDefinitionName;
        Response existingResponse;
        String renamedRef = this.cache.getRenamedRef($ref);
        if (renamedRef != null) {
            return renamedRef;
        }
        Response response = this.cache.loadRef($ref, refFormat, Response.class);
        Map<String, Response> responses = this.swagger.getResponses();
        if (responses == null) {
            responses = new LinkedHashMap<String, Response>();
        }
        if ((existingResponse = responses.get(possiblyConflictingDefinitionName = RefUtils.computeDefinitionName($ref))) != null) {
            LOGGER.debug("A model for " + existingResponse + " already exists");
            if (existingResponse instanceof RefResponse) {
                existingResponse = null;
            }
        }
        String newRef = possiblyConflictingDefinitionName;
        this.cache.putRenamedRef($ref, newRef);
        if (response != null) {
            Object model = null;
            if (response.getResponseSchema() != null) {
                this.processRefSchemaObject(response.getResponseSchema(), $ref);
            }
        }
        return newRef;
    }

    private void processRefSchemaObject(Model schema, String $ref) {
        String file = $ref.split("#/")[0];
        if (schema instanceof RefModel) {
            RefModel refModel = (RefModel)schema;
            RefFormat ref = refModel.getRefFormat();
            if (RefUtils.isAnExternalRefFormat(ref)) {
                this.processRefModel(refModel, $ref);
            } else {
                this.processRefToExternalDefinition(file + refModel.get$ref(), RefFormat.RELATIVE);
            }
        } else {
            this.processSchema(schema, file);
        }
    }

    private void processSchema(Model property, String file) {
        if (property != null) {
            MapProperty mapProperty;
            if (property instanceof RefModel) {
                this.processRefModel((RefModel)property, file);
            }
            if (property.getProperties() != null) {
                this.processProperties(property.getProperties(), file);
            }
            if (property instanceof ArrayModel) {
                this.processProperty(((ArrayModel)property).getItems(), file);
            }
            if (property instanceof MapProperty && (mapProperty = (MapProperty)((Object)property)).getAdditionalProperties() instanceof Model) {
                this.processProperty(mapProperty.getAdditionalProperties(), file);
            }
            if (property instanceof ComposedModel) {
                ComposedModel composed = (ComposedModel)property;
                this.processComposedProperties(composed.getAllOf(), file);
            }
        }
    }

    private void processProperty(Property property, String file) {
    }

    private void processComposedProperties(Collection<Model> properties, String file) {
        if (properties != null) {
            for (Model property : properties) {
                this.processSchema(property, file);
            }
        }
    }

    private void processDiscriminator(String discriminator, Map<String, Property> properties, String file) {
        if (properties == null || properties.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Property> prop : properties.entrySet()) {
            if (!prop.getKey().equals(discriminator)) continue;
            if (prop.getValue() instanceof StringProperty) {
                StringProperty stringProperty = (StringProperty)prop.getValue();
                if (stringProperty.getEnum() == null) continue;
                for (String name : stringProperty.getEnum()) {
                    this.processRefProperty(new RefProperty(RefType.DEFINITION.getInternalPrefix() + name), file);
                }
                continue;
            }
            if (!(prop.getValue() instanceof RefProperty)) continue;
            String ref = ((RefProperty)prop.getValue()).getSimpleRef();
            Map<String, String> renameCache = this.cache.getRenameCache();
            for (String key : renameCache.keySet()) {
                ModelImpl schema;
                Object resolved;
                String value = renameCache.get(key);
                if (!value.equals(ref) || (resolved = this.cache.getResolutionCache().get(key)) == null || !(resolved instanceof ModelImpl) || (schema = (ModelImpl)resolved).getEnum() == null) continue;
                for (String name : schema.getEnum()) {
                    this.processRefProperty(new RefProperty(RefType.DEFINITION.getInternalPrefix() + name), file);
                }
            }
        }
    }

    private void processProperties(Map<String, Property> subProps, String file) {
        if (subProps == null || subProps.isEmpty()) {
            return;
        }
        this.processProperties(subProps.values(), file);
    }

    private void processProperties(Collection<Property> subProps, String file) {
        if (subProps == null || subProps.isEmpty()) {
            return;
        }
        for (Property prop : subProps) {
            if (prop instanceof RefProperty) {
                this.processRefProperty((RefProperty)prop, file);
                continue;
            }
            if (prop instanceof ArrayProperty) {
                this.processProperties(Arrays.asList(((ArrayProperty)prop).getItems()), file);
                continue;
            }
            if (prop instanceof MapProperty) {
                this.processProperties(Arrays.asList(((MapProperty)prop).getAdditionalProperties()), file);
                continue;
            }
            if (prop instanceof ObjectProperty) {
                this.processProperties(((ObjectProperty)prop).getProperties(), file);
                continue;
            }
            if (!(prop instanceof ComposedProperty)) continue;
            this.processProperties(((ComposedProperty)prop).getAllOf(), file);
        }
    }

    private void processDiscriminatorAsRefProperty(RefProperty subRef, String externalFile) {
        if (RefUtils.isAnExternalRefFormat(subRef.getRefFormat())) {
            String joinedRef = ExternalRefProcessor.join(externalFile, subRef.get$ref());
            subRef.set$ref(this.processRefToExternalDefinition(joinedRef, subRef.getRefFormat()));
        } else {
            String processRef = this.processRefToExternalDefinition(externalFile + subRef.get$ref(), RefFormat.RELATIVE);
            subRef.set$ref(RefType.DEFINITION.getInternalPrefix() + processRef);
        }
    }

    private void processRefProperty(RefProperty subRef, String externalFile) {
        if (RefUtils.isAnExternalRefFormat(subRef.getRefFormat())) {
            String joinedRef = ExternalRefProcessor.join(externalFile, subRef.get$ref());
            String processRef = this.processRefToExternalDefinition(joinedRef, subRef.getRefFormat());
            if (processRef.startsWith("http") || processRef.startsWith("https:")) {
                subRef.set$ref(processRef);
            } else {
                subRef.set$ref(RefType.DEFINITION.getInternalPrefix() + processRef);
            }
        } else {
            String processRef = this.processRefToExternalDefinition(externalFile + subRef.get$ref(), RefFormat.RELATIVE);
            subRef.set$ref(RefType.DEFINITION.getInternalPrefix() + processRef);
        }
    }

    private void processRefModel(RefModel subRef, String externalFile) {
        RefFormat format = subRef.getRefFormat();
        if (!RefUtils.isAnExternalRefFormat(format)) {
            subRef.set$ref(RefType.DEFINITION.getInternalPrefix() + this.processRefToExternalDefinition(externalFile + subRef.get$ref(), RefFormat.RELATIVE));
            return;
        }
        String $ref = subRef.get$ref();
        String subRefExternalPath = ExternalRefProcessor.getExternalPath(subRef.get$ref());
        if (format.equals((Object)RefFormat.RELATIVE) && !Objects.equals(subRefExternalPath, externalFile)) {
            $ref = this.constructRef(subRef, externalFile);
            subRef.set$ref($ref);
        } else {
            this.processRefToExternalDefinition($ref, format);
        }
    }

    protected String constructRef(Model refProperty, String rootLocation) {
        RefModel refModel = (RefModel)refProperty;
        String ref = refModel.get$ref();
        return ExternalRefProcessor.join(rootLocation, ref);
    }

    public static String getExternalPath(String ref) {
        if (ref == null) {
            return null;
        }
        String[] elements = ref.split("#/");
        String element = null;
        for (int i = 0; i < elements.length; ++i) {
            if (elements[i].length() != 2) continue;
            element = elements[i];
        }
        return element;
    }

    public static String join(String source, String fragment) {
        try {
            boolean isRelative = false;
            if (source.startsWith("/") || source.startsWith(".")) {
                isRelative = true;
            }
            URI uri = new URI(source);
            if (!source.endsWith("/") && fragment.startsWith("./") && "".equals(uri.getPath())) {
                uri = new URI(source + "/");
            } else if ("".equals(uri.getPath()) && !fragment.startsWith("/")) {
                uri = new URI(source + "/");
            }
            URI f = new URI(fragment);
            URI resolved = uri.resolve(f);
            URI normalized = resolved.normalize();
            if (Character.isAlphabetic(normalized.toString().charAt(0)) && isRelative) {
                return "./" + normalized.toString();
            }
            return normalized.toString();
        }
        catch (Exception e) {
            return source;
        }
    }
}

