/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.swagger.v3.core.jackson;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import znaishaded.com.fasterxml.jackson.core.Version;
import znaishaded.com.fasterxml.jackson.databind.AnnotationIntrospector;
import znaishaded.com.fasterxml.jackson.databind.BeanDescription;
import znaishaded.com.fasterxml.jackson.databind.JavaType;
import znaishaded.com.fasterxml.jackson.databind.Module;
import znaishaded.com.fasterxml.jackson.databind.ObjectMapper;
import znaishaded.com.fasterxml.jackson.databind.PropertyName;
import znaishaded.com.fasterxml.jackson.databind.jsontype.NamedType;
import znaishaded.com.fasterxml.jackson.databind.module.SimpleModule;
import znaishaded.io.swagger.v3.core.converter.AnnotatedType;
import znaishaded.io.swagger.v3.core.converter.ModelConverter;
import znaishaded.io.swagger.v3.core.converter.ModelConverterContext;
import znaishaded.io.swagger.v3.core.jackson.SwaggerAnnotationIntrospector;
import znaishaded.io.swagger.v3.core.jackson.TypeNameResolver;
import znaishaded.io.swagger.v3.core.util.ReflectionUtils;
import znaishaded.io.swagger.v3.oas.models.media.Schema;

public abstract class AbstractModelConverter
implements ModelConverter {
    protected final ObjectMapper _mapper;
    protected final TypeNameResolver _typeNameResolver;
    protected Map<JavaType, String> _resolvedTypeNames = new ConcurrentHashMap<JavaType, String>();

    protected AbstractModelConverter(ObjectMapper mapper) {
        this(mapper, TypeNameResolver.std);
    }

    protected AbstractModelConverter(ObjectMapper mapper, TypeNameResolver typeNameResolver) {
        mapper.registerModule(new SimpleModule("swagger", Version.unknownVersion()){

            @Override
            public void setupModule(Module.SetupContext context) {
                context.insertAnnotationIntrospector(new SwaggerAnnotationIntrospector());
            }
        });
        this._mapper = mapper;
        this._typeNameResolver = typeNameResolver;
    }

    @Override
    public Schema resolve(AnnotatedType type, ModelConverterContext context, Iterator<ModelConverter> chain) {
        if (chain.hasNext()) {
            return chain.next().resolve(type, context, chain);
        }
        return null;
    }

    protected AnnotationIntrospector _intr() {
        return this._mapper.getSerializationConfig().getAnnotationIntrospector();
    }

    protected String _typeName(JavaType type) {
        return this._typeName(type, null);
    }

    protected String _typeName(JavaType type, BeanDescription beanDesc) {
        String name = this._resolvedTypeNames.get(type);
        if (name != null) {
            return name;
        }
        name = this._findTypeName(type, beanDesc);
        this._resolvedTypeNames.put(type, name);
        return name;
    }

    protected String _findTypeName(JavaType type, BeanDescription beanDesc) {
        PropertyName rootName;
        if (type.isArrayType()) {
            return "Array";
        }
        if (type.isMapLikeType() && ReflectionUtils.isSystemType(type)) {
            return "Map";
        }
        if (type.isContainerType() && ReflectionUtils.isSystemType(type)) {
            if (Set.class.isAssignableFrom(type.getRawClass())) {
                return "Set";
            }
            return "List";
        }
        if (beanDesc == null) {
            beanDesc = this._mapper.getSerializationConfig().introspectClassAnnotations(type);
        }
        if ((rootName = this._intr().findRootName(beanDesc.getClassInfo())) != null && rootName.hasSimpleName()) {
            return rootName.getSimpleName();
        }
        return this._typeNameResolver.nameForType(type, new TypeNameResolver.Options[0]);
    }

    protected String _typeQName(JavaType type) {
        return type.getRawClass().getName();
    }

    protected String _subTypeName(NamedType type) {
        return type.getType().getName();
    }

    protected boolean _isSetType(Class<?> cls) {
        if (cls != null) {
            if (Set.class.equals(cls)) {
                return true;
            }
            for (Class<?> a : cls.getInterfaces()) {
                if (!Set.class.equals(a) && !"interface scala.collection.Set".equals(a.toString())) continue;
                return true;
            }
        }
        return false;
    }
}

