/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.swagger.v3.parser.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import znaishaded.io.swagger.v3.oas.models.Components;
import znaishaded.io.swagger.v3.oas.models.OpenAPI;
import znaishaded.io.swagger.v3.oas.models.Operation;
import znaishaded.io.swagger.v3.oas.models.PathItem;
import znaishaded.io.swagger.v3.oas.models.Paths;
import znaishaded.io.swagger.v3.oas.models.SpecVersion;
import znaishaded.io.swagger.v3.oas.models.callbacks.Callback;
import znaishaded.io.swagger.v3.oas.models.examples.Example;
import znaishaded.io.swagger.v3.oas.models.headers.Header;
import znaishaded.io.swagger.v3.oas.models.links.Link;
import znaishaded.io.swagger.v3.oas.models.media.ArraySchema;
import znaishaded.io.swagger.v3.oas.models.media.ComposedSchema;
import znaishaded.io.swagger.v3.oas.models.media.Content;
import znaishaded.io.swagger.v3.oas.models.media.JsonSchema;
import znaishaded.io.swagger.v3.oas.models.media.MapSchema;
import znaishaded.io.swagger.v3.oas.models.media.MediaType;
import znaishaded.io.swagger.v3.oas.models.media.ObjectSchema;
import znaishaded.io.swagger.v3.oas.models.media.Schema;
import znaishaded.io.swagger.v3.oas.models.parameters.Parameter;
import znaishaded.io.swagger.v3.oas.models.parameters.RequestBody;
import znaishaded.io.swagger.v3.oas.models.responses.ApiResponse;
import znaishaded.io.swagger.v3.oas.models.responses.ApiResponses;
import znaishaded.io.swagger.v3.parser.models.RefFormat;
import znaishaded.io.swagger.v3.parser.util.RefUtils;
import znaishaded.io.swagger.v3.parser.util.SchemaTypeUtil;
import znaishaded.org.slf4j.Logger;
import znaishaded.org.slf4j.LoggerFactory;

public class ResolverFully {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResolverFully.class);
    private boolean aggregateCombinators;
    private Map<String, Schema> schemas;
    private Map<String, Schema> resolvedModels = new HashMap<String, Schema>();
    private Map<String, Example> examples;
    private Map<String, Parameter> parameters;
    private Map<String, ApiResponse> responses;
    private Map<String, RequestBody> requestBodies;
    private Map<String, Header> headers;
    private Map<String, Link> links;
    private Map<String, Schema> resolvedProperties = new IdentityHashMap<String, Schema>();
    private Map<String, Callback> callbacks;

    public ResolverFully() {
        this(true);
    }

    public ResolverFully(boolean aggregateCombinators) {
        this.aggregateCombinators = aggregateCombinators;
    }

    public void resolveFully(OpenAPI openAPI) {
        Paths paths;
        Components components = openAPI.getComponents();
        if (components != null && components.getRequestBodies() != null) {
            this.requestBodies = components.getRequestBodies();
            if (this.requestBodies == null) {
                this.requestBodies = new HashMap<String, RequestBody>();
            }
        }
        if (components != null && components.getSchemas() != null) {
            this.schemas = components.getSchemas();
            if (this.schemas == null) {
                this.schemas = new HashMap<String, Schema>();
            }
        }
        if (components != null && components.getResponses() != null) {
            this.responses = components.getResponses();
            if (this.responses == null) {
                this.responses = new HashMap<String, ApiResponse>();
            }
        }
        if (components != null && components.getExamples() != null) {
            this.examples = components.getExamples();
            if (this.examples == null) {
                this.examples = new HashMap<String, Example>();
            }
        }
        if (components != null && components.getHeaders() != null) {
            this.headers = components.getHeaders();
            if (this.headers == null) {
                this.headers = new HashMap<String, Header>();
            }
        }
        if (components != null && components.getParameters() != null) {
            this.parameters = components.getParameters();
            if (this.parameters == null) {
                this.parameters = new HashMap<String, Parameter>();
            }
        }
        if (components != null && components.getLinks() != null) {
            this.links = components.getLinks();
            if (this.links == null) {
                this.links = new HashMap<String, Link>();
            }
        }
        if (components != null && components.getCallbacks() != null) {
            this.callbacks = components.getCallbacks();
            if (this.callbacks == null) {
                this.callbacks = new HashMap<String, Callback>();
            }
        }
        if ((paths = openAPI.getPaths()) != null) {
            for (String pathname : paths.keySet()) {
                PathItem pathItem = (PathItem)paths.get(pathname);
                this.resolvePath(pathItem);
            }
        }
    }

    public void resolvePath(PathItem pathItem) {
        for (Operation op : pathItem.readOperations()) {
            ApiResponses apiResponses;
            RequestBody refRequestBody;
            Content content;
            if (op.getParameters() != null) {
                for (Parameter parameter : op.getParameters()) {
                    Schema resolved;
                    Parameter parameter2;
                    Parameter parameter3 = parameter2 = parameter.get$ref() != null ? this.resolveParameter(parameter) : parameter;
                    if (parameter2.getSchema() != null && (resolved = this.resolveSchema(parameter2.getSchema())) != null) {
                        parameter2.setSchema(resolved);
                    }
                    if (parameter2.getContent() == null) continue;
                    content = parameter2.getContent();
                    for (Object key : content.keySet()) {
                        Schema resolvedSchema;
                        if (content.get(key) == null || ((MediaType)content.get(key)).getSchema() == null || (resolvedSchema = this.resolveSchema(((MediaType)content.get(key)).getSchema())) == null) continue;
                        ((MediaType)content.get(key)).setSchema(resolvedSchema);
                    }
                }
            }
            if (op.getCallbacks() != null) {
                Map<String, Callback> callbacks = op.getCallbacks();
                for (String name : callbacks.keySet()) {
                    Callback callback = callbacks.get(name);
                    Callback callback2 = callback = callback.get$ref() != null ? this.resolveCallback(callback) : callback;
                    if (callback != null) {
                        Object key;
                        key = callback.keySet().iterator();
                        while (key.hasNext()) {
                            String callbackName = (String)key.next();
                            PathItem path = (PathItem)callback.get(callbackName);
                            if (path == null) continue;
                            this.resolvePath(path);
                        }
                    }
                    op.getCallbacks().put(name, callback);
                }
            }
            if ((refRequestBody = op.getRequestBody()) != null) {
                RequestBody requestBody = refRequestBody.get$ref() != null ? this.resolveRequestBody(refRequestBody) : refRequestBody;
                op.setRequestBody(requestBody);
                if (requestBody.getContent() != null) {
                    content = requestBody.getContent();
                    for (Object key : content.keySet()) {
                        Schema resolved;
                        if (content.get(key) == null || ((MediaType)content.get(key)).getSchema() == null || (resolved = this.resolveSchema(((MediaType)content.get(key)).getSchema())) == null) continue;
                        ((MediaType)content.get(key)).setSchema(resolved);
                    }
                }
            }
            if ((apiResponses = op.getResponses()) == null) continue;
            ApiResponses resolvedResponses = new ApiResponses();
            for (String code : apiResponses.keySet()) {
                ApiResponse response = (ApiResponse)apiResponses.get(code);
                ApiResponse apiResponse = response = response.get$ref() != null ? this.resolveResponse(response) : response;
                if (response.getContent() != null) {
                    Content content2 = response.getContent();
                    for (String string : content2.keySet()) {
                        Object resolved;
                        if (((MediaType)content2.get(string)).getSchema() != null) {
                            resolved = this.resolveSchema(((MediaType)content2.get(string)).getSchema());
                            ((MediaType)response.getContent().get(string)).setSchema((Schema)resolved);
                        }
                        if (((MediaType)content2.get(string)).getExamples() == null) continue;
                        resolved = this.resolveExample(((MediaType)content2.get(string)).getExamples());
                        ((MediaType)response.getContent().get(string)).setExamples((Map<String, Example>)resolved);
                    }
                }
                this.resolveHeaders(response.getHeaders());
                Map<String, Link> links = response.getLinks();
                if (links != null) {
                    for (Map.Entry entry : links.entrySet()) {
                        Link value = (Link)entry.getValue();
                        Link resolvedValue = value.get$ref() != null ? this.resolveLink(value) : value;
                        entry.setValue(resolvedValue);
                    }
                }
                resolvedResponses.addApiResponse(code, response);
            }
            op.setResponses(resolvedResponses);
        }
    }

    private void resolveHeaders(Map<String, Header> headers) {
        if (headers == null || headers.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Header> header : headers.entrySet()) {
            Schema resolvedSchema;
            Schema schema;
            Header value = header.getValue();
            Header resolvedValue = value.get$ref() != null ? this.resolveHeader(value) : value;
            Map<String, Example> examples = resolvedValue.getExamples();
            if (examples != null) {
                Map<String, Example> resolved = this.resolveExample(examples);
                resolvedValue.setExamples(resolved);
            }
            if ((schema = resolvedValue.getSchema()) != null && (resolvedSchema = this.resolveSchema(schema)) != null) {
                resolvedValue.setSchema(resolvedSchema);
            }
            header.setValue(resolvedValue);
        }
    }

    public Header resolveHeader(Header header) {
        RefFormat refFormat = RefUtils.computeRefFormat(header.get$ref());
        String $ref = header.get$ref();
        if (!RefUtils.isAnExternalRefFormat(refFormat) && this.headers != null && !this.headers.isEmpty()) {
            String referenceKey = RefUtils.computeDefinitionName($ref);
            return this.headers.getOrDefault(referenceKey, header);
        }
        return header;
    }

    public Link resolveLink(Link link) {
        RefFormat refFormat = RefUtils.computeRefFormat(link.get$ref());
        String $ref = link.get$ref();
        if (!RefUtils.isAnExternalRefFormat(refFormat) && this.links != null && !this.links.isEmpty()) {
            String referenceKey = RefUtils.computeDefinitionName($ref);
            Link link1 = this.links.getOrDefault(referenceKey, link);
            if (link1 == null) {
                return null;
            }
            this.resolveHeaders(link1.getHeaders());
            return link1;
        }
        return link;
    }

    public RequestBody resolveRequestBody(RequestBody requestBody) {
        RefFormat refFormat = RefUtils.computeRefFormat(requestBody.get$ref());
        String $ref = requestBody.get$ref();
        if (!RefUtils.isAnExternalRefFormat(refFormat) && this.requestBodies != null && !this.requestBodies.isEmpty()) {
            String referenceKey = RefUtils.computeDefinitionName($ref);
            return this.requestBodies.getOrDefault(referenceKey, requestBody);
        }
        return requestBody;
    }

    public ApiResponse resolveResponse(ApiResponse apiResponse) {
        RefFormat refFormat = RefUtils.computeRefFormat(apiResponse.get$ref());
        String $ref = apiResponse.get$ref();
        if (!RefUtils.isAnExternalRefFormat(refFormat) && this.responses != null && !this.responses.isEmpty()) {
            String referenceKey = RefUtils.computeDefinitionName($ref);
            return this.responses.getOrDefault(referenceKey, apiResponse);
        }
        return apiResponse;
    }

    public Callback resolveCallback(Callback callback) {
        RefFormat refFormat = RefUtils.computeRefFormat(callback.get$ref());
        String $ref = callback.get$ref();
        if (!RefUtils.isAnExternalRefFormat(refFormat) && this.callbacks != null && !this.callbacks.isEmpty()) {
            String referenceKey = RefUtils.computeDefinitionName($ref);
            return this.callbacks.getOrDefault(referenceKey, callback);
        }
        return callback;
    }

    public Parameter resolveParameter(Parameter parameter) {
        String $ref = parameter.get$ref();
        RefFormat refFormat = RefUtils.computeRefFormat($ref);
        if (!RefUtils.isAnExternalRefFormat(refFormat) && this.parameters != null && !this.parameters.isEmpty()) {
            String referenceKey = RefUtils.computeDefinitionName($ref);
            return this.parameters.getOrDefault(referenceKey, parameter);
        }
        return parameter;
    }

    public Schema resolveSchema(Schema schema) {
        MapSchema mapSchema;
        if (schema == null) {
            return null;
        }
        if (schema.get$ref() != null) {
            Schema resolved;
            String ref = schema.get$ref();
            if (ref.contains("/properties/")) {
                String[] split = ref.split("/");
                String refSchema = split[3];
                Schema parentSchema = this.schemas.get(refSchema);
                ref = ref.substring(ref.lastIndexOf("/") + 1);
                resolved = parentSchema.getProperties().get(ref);
            } else {
                ref = ref.substring(ref.lastIndexOf("/") + 1);
                Schema schema2 = resolved = this.schemas != null ? this.schemas.get(ref) : null;
            }
            if (resolved != null) {
                if (this.resolvedModels.containsKey(ref)) {
                    LOGGER.debug("avoiding infinite loop");
                    return this.resolvedModels.get(ref);
                }
                this.resolvedModels.put(ref, schema);
                Schema model = this.resolveSchema(resolved);
                this.resolvedModels.put(ref, model);
                this.schemas.put(ref, model);
                return model;
            }
            return schema;
        }
        if (schema instanceof ArraySchema) {
            ArraySchema arrayModel = (ArraySchema)schema;
            arrayModel.setItems(this.resolveSchema(arrayModel.getItems()));
            return arrayModel;
        }
        if (schema instanceof MapSchema && (mapSchema = (MapSchema)schema).getAdditionalProperties() instanceof Schema) {
            Schema additionalPropertiesSchema = (Schema)mapSchema.getAdditionalProperties();
            mapSchema.setAdditionalProperties(this.resolveSchema(additionalPropertiesSchema));
        }
        if (schema instanceof ObjectSchema) {
            ObjectSchema obj = (ObjectSchema)schema;
            if (obj.getProperties() != null) {
                LinkedHashMap<String, Schema> updated = new LinkedHashMap<String, Schema>();
                for (String propertyName : obj.getProperties().keySet()) {
                    Schema innerProperty = obj.getProperties().get(propertyName);
                    if (schema == innerProperty) continue;
                    updated.put(propertyName, this.resolveSchemaProperty(propertyName, innerProperty));
                }
                obj.setProperties(updated);
            }
            return obj;
        }
        Schema result = schema;
        if (schema instanceof ComposedSchema) {
            boolean adjacent;
            ComposedSchema composedSchema = (ComposedSchema)schema;
            boolean hasAllOf = composedSchema.getAllOf() != null;
            boolean hasAnyOf = composedSchema.getAnyOf() != null;
            boolean hasOneOf = composedSchema.getOneOf() != null;
            boolean bl = adjacent = hasAllOf && hasAnyOf || hasAllOf && hasOneOf || hasAnyOf && hasOneOf;
            if (this.aggregateCombinators && (hasAllOf || adjacent)) {
                Schema combinedModel = null;
                if (SpecVersion.V30.equals((Object)composedSchema.getSpecVersion())) {
                    combinedModel = SchemaTypeUtil.createSchema(this.getSchemaType(composedSchema), composedSchema.getFormat());
                } else {
                    combinedModel = new JsonSchema();
                    combinedModel.setFormat(composedSchema.getFormat());
                    combinedModel.setTypes(composedSchema.getTypes());
                }
                HashSet<Object> examples = new HashSet<Object>();
                HashSet<Object> defaultValues = new HashSet<Object>();
                if (hasAllOf) {
                    this.aggregateSchemaCombinators(composedSchema, combinedModel, composedSchema.getAllOf(), examples, defaultValues);
                }
                if (hasOneOf) {
                    this.aggregateSchemaCombinators(composedSchema, combinedModel, composedSchema.getOneOf(), examples, defaultValues);
                }
                if (hasAnyOf) {
                    this.aggregateSchemaCombinators(composedSchema, combinedModel, composedSchema.getAnyOf(), examples, defaultValues);
                }
                if (defaultValues.size() == 1) {
                    combinedModel.setDefault(defaultValues.iterator().next());
                }
                if (schema.getExample() != null) {
                    combinedModel.setExample(schema.getExample());
                } else if (!examples.isEmpty()) {
                    combinedModel.setExample(examples);
                }
                if (schema.getXml() != null) {
                    combinedModel.setXml(schema.getXml());
                }
                if (schema.getDescription() != null) {
                    combinedModel.setDescription(schema.getDescription());
                }
                if (schema.getExtensions() != null) {
                    Map<String, Object> extensions = schema.getExtensions();
                    for (String key : extensions.keySet()) {
                        combinedModel.addExtension(key, extensions.get(key));
                    }
                }
                if (schema.getProperties() != null) {
                    if (combinedModel.getProperties() == null) {
                        combinedModel.setProperties(new HashMap<String, Schema>());
                    }
                    combinedModel.getProperties().putAll(schema.getProperties());
                }
                if (schema.getRequired() != null) {
                    if (combinedModel.getRequired() == null) {
                        combinedModel.required(new ArrayList<String>());
                    }
                    combinedModel.getRequired().addAll(schema.getRequired());
                }
                result = combinedModel;
            } else {
                if (hasAllOf) {
                    composedSchema.allOf(composedSchema.getAllOf().stream().map(this::resolveSchema).collect(Collectors.toList()));
                }
                if (hasOneOf) {
                    composedSchema.oneOf(composedSchema.getOneOf().stream().map(this::resolveSchema).collect(Collectors.toList()));
                }
                if (hasAnyOf) {
                    composedSchema.anyOf(composedSchema.getAnyOf().stream().map(this::resolveSchema).collect(Collectors.toList()));
                }
            }
        }
        if (result.getProperties() != null) {
            Schema property;
            Schema model = result;
            LinkedHashMap<String, Schema> updated = new LinkedHashMap<String, Schema>();
            Map<String, Schema> properties = model.getProperties();
            for (String propertyName : properties.keySet()) {
                property = model.getProperties().get(propertyName);
                updated.put(propertyName, this.resolveSchemaProperty(propertyName, property));
            }
            for (String key : updated.keySet()) {
                property = (Schema)updated.get(key);
                if (property.getProperties() != model.getProperties()) {
                    if (!this.hasSchemaType(property)) {
                        if (SpecVersion.V30.equals((Object)property.getSpecVersion())) {
                            property.setType("object");
                        } else {
                            property.addType("object");
                        }
                    }
                    model.addProperties(key, property);
                    continue;
                }
                LOGGER.debug("not adding recursive properties, using generic object");
                ObjectSchema newSchema = new ObjectSchema();
                model.addProperties(key, newSchema);
            }
            return model;
        }
        return result;
    }

    protected String getSchemaType(Schema schema) {
        if (SpecVersion.V30.equals((Object)schema.getSpecVersion())) {
            return schema.getType();
        }
        if (schema.getTypes() != null && schema.getTypes().size() == 1) {
            return schema.getTypes().iterator().next();
        }
        return null;
    }

    protected boolean hasSchemaType(Schema schema) {
        if (SpecVersion.V30.equals((Object)schema.getSpecVersion())) {
            return schema.getType() != null;
        }
        return schema.getTypes() != null && schema.getTypes().size() > 0;
    }

    public Map<String, Example> resolveExample(Map<String, Example> examples) {
        Map<String, Example> resolveExamples = examples;
        if (examples != null) {
            for (String name : examples.keySet()) {
                if (examples.get(name).get$ref() == null) continue;
                String ref = examples.get(name).get$ref();
                ref = ref.substring(ref.lastIndexOf("/") + 1);
                Example sample = this.examples.get(ref);
                resolveExamples.replace(name, sample);
            }
        }
        return resolveExamples;
    }

    private void aggregateSchemaCombinators(ComposedSchema sourceSchema, Schema targetSchema, List<Schema> schemasToAggregate, Set<Object> examples, Set<Object> defaultValues) {
        HashSet<String> requiredProperties = new HashSet<String>();
        for (Schema innerModel : schemasToAggregate) {
            Map<String, Object> extensions;
            boolean hasOneOf;
            Schema resolved = this.resolveSchema(innerModel);
            Map<String, Schema> properties = resolved.getProperties();
            if (resolved.getProperties() != null) {
                for (String key : properties.keySet()) {
                    Schema prop = resolved.getProperties().get(key);
                    targetSchema.addProperties(key, this.resolveSchemaProperty(key, prop));
                }
                if (resolved.getRequired() != null) {
                    for (String required : resolved.getRequired()) {
                        if (required == null) continue;
                        requiredProperties.add(required.toString());
                    }
                }
            }
            boolean hasAllOf = innerModel.getAllOf() != null;
            boolean hasAnyOf = innerModel.getAnyOf() != null;
            boolean bl = hasOneOf = innerModel.getOneOf() != null;
            if (hasAllOf) {
                this.aggregateSchemaCombinators(sourceSchema, targetSchema, innerModel.getAllOf(), examples, defaultValues);
            }
            if (hasOneOf) {
                this.aggregateSchemaCombinators(sourceSchema, targetSchema, innerModel.getOneOf(), examples, defaultValues);
            }
            if (hasAnyOf) {
                this.aggregateSchemaCombinators(sourceSchema, targetSchema, innerModel.getAnyOf(), examples, defaultValues);
            }
            if (resolved.getEnum() != null) {
                targetSchema.setEnum(resolved.getEnum());
            }
            if (resolved.getExample() != null) {
                examples.add(resolved.getExample());
            }
            if (sourceSchema.getDefault() != null && resolved.getDefault() == null) {
                defaultValues.add(sourceSchema.getDefault());
            } else {
                defaultValues.add(resolved.getDefault());
            }
            if (resolved.getExtensions() != null) {
                extensions = resolved.getExtensions();
                for (String key : extensions.keySet()) {
                    targetSchema.addExtension(key, extensions.get(key));
                }
            }
            if (sourceSchema.getExtensions() != null) {
                extensions = sourceSchema.getExtensions();
                for (String key : extensions.keySet()) {
                    targetSchema.addExtension(key, sourceSchema.getExtensions().get(key));
                }
            }
            if (resolved.getMaximum() != null) {
                targetSchema.setMaximum(resolved.getMaximum());
            }
            if (resolved.getExclusiveMaximum() != null) {
                targetSchema.setExclusiveMaximum(resolved.getExclusiveMaximum());
            }
            if (resolved.getMinimum() != null) {
                targetSchema.setMinimum(resolved.getMinimum());
            }
            if (resolved.getExclusiveMinimum() != null) {
                targetSchema.setExclusiveMinimum(resolved.getExclusiveMinimum());
            }
            if (resolved.getMaxLength() != null) {
                targetSchema.setMaxLength(resolved.getMaxLength());
            }
            if (resolved.getMinLength() != null) {
                targetSchema.setMinLength(resolved.getMinLength());
            }
            if (resolved.getPattern() != null) {
                targetSchema.setPattern(resolved.getPattern());
            }
            if (resolved.getMaxItems() != null) {
                targetSchema.setMaxItems(resolved.getMaxItems());
            }
            if (resolved.getMinItems() != null) {
                targetSchema.setMinItems(resolved.getMinItems());
            }
            if (resolved.getUniqueItems() != null) {
                targetSchema.setUniqueItems(resolved.getUniqueItems());
            }
            if (resolved.getMaxProperties() != null) {
                targetSchema.setMaxProperties(resolved.getMaxProperties());
            }
            if (resolved.getMinProperties() != null) {
                targetSchema.setMinProperties(resolved.getMinProperties());
            }
            if (resolved.getType() != null) {
                targetSchema.setType(resolved.getType());
            }
            if (resolved.getDescription() != null) {
                targetSchema.setDescription(resolved.getDescription());
            }
            if (resolved.getFormat() != null) {
                targetSchema.setFormat(resolved.getFormat());
            }
            if (resolved.getNullable() != null) {
                targetSchema.setNullable(resolved.getNullable());
            }
            if (resolved.getReadOnly() != null) {
                targetSchema.setReadOnly(resolved.getReadOnly());
            }
            if (resolved.getWriteOnly() != null) {
                targetSchema.setWriteOnly(resolved.getWriteOnly());
            }
            if (resolved.getExclusiveMaximumValue() != null) {
                targetSchema.setExclusiveMaximumValue(resolved.getExclusiveMaximumValue());
            }
            if (resolved.getExclusiveMinimumValue() != null) {
                targetSchema.setExclusiveMinimumValue(resolved.getExclusiveMinimumValue());
            }
            if (resolved.getMaxContains() != null) {
                targetSchema.setMaxContains(resolved.getMaxContains());
            }
            if (resolved.getMinContains() == null) continue;
            targetSchema.setMinContains(resolved.getMinContains());
        }
        if (requiredProperties.size() > 0) {
            ArrayList<String> required = new ArrayList<String>();
            if (targetSchema.getRequired() != null) {
                required.addAll(targetSchema.getRequired());
            }
            required.addAll(requiredProperties);
            targetSchema.setRequired(required);
        }
    }

    private Schema resolveSchemaProperty(String propertyName, Schema innerProperty) {
        if (this.resolvedProperties.get(propertyName) == null || this.resolvedProperties.get(propertyName) != innerProperty) {
            LOGGER.debug("avoiding infinite loop");
            Schema resolved = this.resolveSchema(innerProperty);
            this.resolvedProperties.put(propertyName, resolved);
            return resolved;
        }
        return this.resolvedProperties.get(propertyName);
    }
}

