/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.core.http.impl;

import java.util.ArrayList;
import java.util.List;
import znaishaded.io.netty.handler.codec.http.DefaultHttpHeaders;
import znaishaded.io.vertx.core.Handler;
import znaishaded.io.vertx.core.MultiMap;
import znaishaded.io.vertx.core.buffer.Buffer;
import znaishaded.io.vertx.core.http.HttpClientResponse;
import znaishaded.io.vertx.core.http.HttpConnection;
import znaishaded.io.vertx.core.http.HttpFrame;
import znaishaded.io.vertx.core.http.HttpHeaders;
import znaishaded.io.vertx.core.http.HttpVersion;
import znaishaded.io.vertx.core.http.StreamPriority;
import znaishaded.io.vertx.core.http.impl.HeadersAdaptor;
import znaishaded.io.vertx.core.http.impl.HttpClientRequestBase;
import znaishaded.io.vertx.core.http.impl.HttpClientStream;
import znaishaded.io.vertx.core.logging.Logger;
import znaishaded.io.vertx.core.logging.LoggerFactory;
import znaishaded.io.vertx.core.net.NetSocket;

public class HttpClientResponseImpl
implements HttpClientResponse {
    private static final Logger log = LoggerFactory.getLogger(HttpClientResponseImpl.class);
    private final HttpVersion version;
    private final int statusCode;
    private final String statusMessage;
    private final HttpClientRequestBase request;
    private final HttpConnection conn;
    private final HttpClientStream stream;
    private Handler<Buffer> dataHandler;
    private Handler<HttpFrame> customFrameHandler;
    private Handler<Void> endHandler;
    private Handler<Throwable> exceptionHandler;
    private Handler<StreamPriority> priorityHandler;
    private NetSocket netSocket;
    private MultiMap headers;
    private MultiMap trailers;
    private List<String> cookies;

    HttpClientResponseImpl(HttpClientRequestBase request, HttpVersion version, HttpClientStream stream, int statusCode, String statusMessage, MultiMap headers) {
        this.version = version;
        this.statusCode = statusCode;
        this.statusMessage = statusMessage;
        this.request = request;
        this.stream = stream;
        this.conn = stream.connection();
        this.headers = headers;
    }

    @Override
    public HttpClientRequestBase request() {
        return this.request;
    }

    @Override
    public HttpVersion version() {
        return this.version;
    }

    @Override
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    public String statusMessage() {
        return this.statusMessage;
    }

    @Override
    public MultiMap headers() {
        return this.headers;
    }

    @Override
    public String getHeader(String headerName) {
        return this.headers.get(headerName);
    }

    @Override
    public String getHeader(CharSequence headerName) {
        return this.headers.get(headerName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MultiMap trailers() {
        HttpConnection httpConnection = this.conn;
        synchronized (httpConnection) {
            if (this.trailers == null) {
                this.trailers = new HeadersAdaptor(new DefaultHttpHeaders());
            }
            return this.trailers;
        }
    }

    @Override
    public String getTrailer(String trailerName) {
        return this.trailers != null ? this.trailers.get(trailerName) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> cookies() {
        HttpConnection httpConnection = this.conn;
        synchronized (httpConnection) {
            if (this.cookies == null) {
                this.cookies = new ArrayList<String>();
                this.cookies.addAll(this.headers().getAll(HttpHeaders.SET_COOKIE));
                if (this.trailers != null) {
                    this.cookies.addAll(this.trailers.getAll(HttpHeaders.SET_COOKIE));
                }
            }
            return this.cookies;
        }
    }

    private void checkEnded() {
        if (this.trailers != null) {
            throw new IllegalStateException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClientResponse handler(Handler<Buffer> handler) {
        HttpConnection httpConnection = this.conn;
        synchronized (httpConnection) {
            if (handler != null) {
                this.checkEnded();
            }
            this.dataHandler = handler;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClientResponse endHandler(Handler<Void> handler) {
        HttpConnection httpConnection = this.conn;
        synchronized (httpConnection) {
            if (handler != null) {
                this.checkEnded();
            }
            this.endHandler = handler;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClientResponse exceptionHandler(Handler<Throwable> handler) {
        HttpConnection httpConnection = this.conn;
        synchronized (httpConnection) {
            if (handler != null) {
                this.checkEnded();
            }
            this.exceptionHandler = handler;
            return this;
        }
    }

    @Override
    public HttpClientResponse pause() {
        this.stream.doPause();
        return this;
    }

    @Override
    public HttpClientResponse resume() {
        return this.fetch(Long.MAX_VALUE);
    }

    @Override
    public HttpClientResponse fetch(long amount) {
        this.stream.doFetch(amount);
        return this;
    }

    @Override
    public HttpClientResponse bodyHandler(Handler<Buffer> handler) {
        if (handler != null) {
            BodyHandler bodyHandler = new BodyHandler();
            this.handler((Handler)bodyHandler);
            this.endHandler(v -> bodyHandler.notifyHandler(handler));
        } else {
            this.handler((Handler)null);
            this.endHandler((Handler)null);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClientResponse customFrameHandler(Handler<HttpFrame> handler) {
        HttpConnection httpConnection = this.conn;
        synchronized (httpConnection) {
            if (this.endHandler != null) {
                this.checkEnded();
            }
            this.customFrameHandler = handler;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleUnknownFrame(HttpFrame frame) {
        HttpConnection httpConnection = this.conn;
        synchronized (httpConnection) {
            if (this.customFrameHandler != null) {
                try {
                    this.customFrameHandler.handle(frame);
                }
                catch (Throwable t) {
                    this.handleException(t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleChunk(Buffer data) {
        Handler<Buffer> handler;
        this.request.dataReceived();
        HttpConnection httpConnection = this.conn;
        synchronized (httpConnection) {
            handler = this.dataHandler;
        }
        if (handler != null) {
            try {
                handler.handle(data);
            }
            catch (Throwable t) {
                this.handleException(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleEnd(MultiMap trailers) {
        Handler<Void> handler;
        HttpConnection httpConnection = this.conn;
        synchronized (httpConnection) {
            this.trailers = trailers;
            handler = this.endHandler;
            this.endHandler = null;
        }
        if (handler != null) {
            try {
                handler.handle(null);
            }
            catch (Throwable t) {
                this.handleException(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleException(Throwable e) {
        Handler<Throwable> handler;
        HttpConnection httpConnection = this.conn;
        synchronized (httpConnection) {
            handler = this.exceptionHandler;
            if (handler == null) {
                handler = log::error;
            }
        }
        handler.handle(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NetSocket netSocket() {
        HttpConnection httpConnection = this.conn;
        synchronized (httpConnection) {
            if (this.netSocket == null) {
                this.netSocket = this.stream.createNetSocket();
            }
            return this.netSocket;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClientResponse streamPriorityHandler(Handler<StreamPriority> handler) {
        HttpConnection httpConnection = this.conn;
        synchronized (httpConnection) {
            if (handler != null) {
                this.checkEnded();
            }
            this.priorityHandler = handler;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handlePriorityChange(StreamPriority streamPriority) {
        Handler<StreamPriority> handler;
        HttpConnection httpConnection = this.conn;
        synchronized (httpConnection) {
            handler = this.priorityHandler;
            if (handler == null) {
                return;
            }
        }
        handler.handle(streamPriority);
    }

    private static final class BodyHandler
    implements Handler<Buffer> {
        private Buffer body;

        private BodyHandler() {
        }

        @Override
        public void handle(Buffer event) {
            this.body().appendBuffer(event);
        }

        private Buffer body() {
            if (this.body == null) {
                this.body = Buffer.buffer();
            }
            return this.body;
        }

        void notifyHandler(Handler<Buffer> bodyHandler) {
            bodyHandler.handle(this.body());
            this.body = null;
        }
    }
}

