/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.core.json;

import java.io.IOException;
import java.time.Instant;
import java.util.Base64;
import znaishaded.com.fasterxml.jackson.core.JsonParser;
import znaishaded.com.fasterxml.jackson.core.JsonProcessingException;
import znaishaded.com.fasterxml.jackson.databind.DeserializationContext;
import znaishaded.com.fasterxml.jackson.databind.JsonDeserializer;
import znaishaded.com.fasterxml.jackson.databind.exc.InvalidFormatException;

class ByteArrayDeserializer
extends JsonDeserializer<byte[]> {
    ByteArrayDeserializer() {
    }

    @Override
    public byte[] deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        String text = p.getText();
        try {
            return Base64.getDecoder().decode(text);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidFormatException(p, "Expected a base64 encoded byte array", (Object)text, Instant.class);
        }
    }
}

