/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.core.net.impl.transport;

import java.net.InetSocketAddress;
import java.util.concurrent.ThreadFactory;
import znaishaded.io.netty.bootstrap.ServerBootstrap;
import znaishaded.io.netty.channel.Channel;
import znaishaded.io.netty.channel.ChannelFactory;
import znaishaded.io.netty.channel.EventLoopGroup;
import znaishaded.io.netty.channel.ServerChannel;
import znaishaded.io.netty.channel.kqueue.KQueue;
import znaishaded.io.netty.channel.kqueue.KQueueChannelOption;
import znaishaded.io.netty.channel.kqueue.KQueueDatagramChannel;
import znaishaded.io.netty.channel.kqueue.KQueueDomainSocketChannel;
import znaishaded.io.netty.channel.kqueue.KQueueEventLoopGroup;
import znaishaded.io.netty.channel.kqueue.KQueueServerDomainSocketChannel;
import znaishaded.io.netty.channel.kqueue.KQueueServerSocketChannel;
import znaishaded.io.netty.channel.kqueue.KQueueSocketChannel;
import znaishaded.io.netty.channel.socket.DatagramChannel;
import znaishaded.io.netty.channel.socket.InternetProtocolFamily;
import znaishaded.io.netty.channel.unix.DomainSocketAddress;
import znaishaded.io.vertx.core.datagram.DatagramSocketOptions;
import znaishaded.io.vertx.core.net.NetServerOptions;
import znaishaded.io.vertx.core.net.SocketAddress;
import znaishaded.io.vertx.core.net.impl.SocketAddressImpl;
import znaishaded.io.vertx.core.net.impl.transport.Transport;

class KQueueTransport
extends Transport {
    KQueueTransport() {
    }

    @Override
    public java.net.SocketAddress convert(SocketAddress address, boolean resolved) {
        if (address.path() != null) {
            return new DomainSocketAddress(address.path());
        }
        if (resolved) {
            return new InetSocketAddress(address.host(), address.port());
        }
        return InetSocketAddress.createUnresolved(address.host(), address.port());
    }

    @Override
    public SocketAddress convert(java.net.SocketAddress address) {
        if (address instanceof DomainSocketAddress) {
            return new SocketAddressImpl(((DomainSocketAddress)address).path());
        }
        return super.convert(address);
    }

    @Override
    public boolean isAvailable() {
        return KQueue.isAvailable();
    }

    @Override
    public Throwable unavailabilityCause() {
        return KQueue.unavailabilityCause();
    }

    @Override
    public EventLoopGroup eventLoopGroup(int type, int nThreads, ThreadFactory threadFactory, int ioRatio) {
        KQueueEventLoopGroup eventLoopGroup = new KQueueEventLoopGroup(nThreads, threadFactory);
        eventLoopGroup.setIoRatio(ioRatio);
        return eventLoopGroup;
    }

    @Override
    public DatagramChannel datagramChannel() {
        return new KQueueDatagramChannel();
    }

    @Override
    public DatagramChannel datagramChannel(InternetProtocolFamily family) {
        return new KQueueDatagramChannel();
    }

    @Override
    public ChannelFactory<? extends Channel> channelFactory(boolean domainSocket) {
        if (domainSocket) {
            return KQueueDomainSocketChannel::new;
        }
        return KQueueSocketChannel::new;
    }

    @Override
    public ChannelFactory<? extends ServerChannel> serverChannelFactory(boolean domainSocket) {
        if (domainSocket) {
            return KQueueServerDomainSocketChannel::new;
        }
        return KQueueServerSocketChannel::new;
    }

    @Override
    public void configure(NetServerOptions options, boolean domainSocket, ServerBootstrap bootstrap) {
        if (!domainSocket) {
            bootstrap.option(KQueueChannelOption.SO_REUSEPORT, options.isReusePort());
        }
        super.configure(options, domainSocket, bootstrap);
    }

    @Override
    public void configure(DatagramChannel channel, DatagramSocketOptions options) {
        channel.config().setOption(KQueueChannelOption.SO_REUSEPORT, options.isReusePort());
        super.configure(channel, options);
    }
}

