/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.abel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import znaishaded.net.sourceforge.plantuml.abel.Entity;
import znaishaded.net.sourceforge.plantuml.abel.GroupType;
import znaishaded.net.sourceforge.plantuml.abel.IEntityFactory;
import znaishaded.net.sourceforge.plantuml.abel.LeafType;
import znaishaded.net.sourceforge.plantuml.abel.Link;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Bodier;
import znaishaded.net.sourceforge.plantuml.cucadiagram.BodierJSon;
import znaishaded.net.sourceforge.plantuml.cucadiagram.BodierMap;
import znaishaded.net.sourceforge.plantuml.cucadiagram.BodyFactory;
import znaishaded.net.sourceforge.plantuml.cucadiagram.HideOrShow;
import znaishaded.net.sourceforge.plantuml.cucadiagram.ICucaDiagram;
import znaishaded.net.sourceforge.plantuml.plasma.Plasma;
import znaishaded.net.sourceforge.plantuml.plasma.Quark;
import znaishaded.net.sourceforge.plantuml.skin.VisibilityModifier;
import znaishaded.net.sourceforge.plantuml.stereo.Stereotype;

public final class EntityFactory
implements IEntityFactory {
    private final List<Link> links = new ArrayList<Link>();
    private int rawLayout;
    private final Plasma<Entity> namespace;
    private final Quark<Entity> root;
    private final Entity rootGroup;
    private final List<HideOrShow> hides2;
    private final List<HideOrShow> removed;
    private final ICucaDiagram diagram;

    public EntityFactory(List<HideOrShow> hides2, List<HideOrShow> removed, ICucaDiagram diagram) {
        this.hides2 = hides2;
        this.removed = removed;
        this.diagram = diagram;
        this.namespace = new Plasma();
        this.root = this.namespace.root();
        this.rootGroup = new Entity(this.root, this, null, GroupType.ROOT, 0);
    }

    public boolean isHidden(Entity leaf) {
        Entity other = this.isNoteWithSingleLinkAttachedTo(leaf);
        if (other != null && other != leaf) {
            return this.isHidden(other);
        }
        boolean hidden = false;
        for (HideOrShow hide : this.hides2) {
            hidden = hide.apply(hidden, leaf);
        }
        return hidden;
    }

    @Override
    public boolean isRemoved(Stereotype stereotype) {
        boolean result = false;
        for (HideOrShow hide : this.removed) {
            result = hide.apply(result, stereotype);
        }
        return result;
    }

    public boolean isRemoved(Entity leaf) {
        Entity other = this.isNoteWithSingleLinkAttachedTo(leaf);
        if (other instanceof Entity) {
            return this.isRemoved(other);
        }
        boolean result = false;
        for (HideOrShow hide : this.removed) {
            result = hide.apply(result, leaf);
        }
        return result;
    }

    private Entity isNoteWithSingleLinkAttachedTo(Entity note) {
        if (note.getLeafType() != LeafType.NOTE) {
            return null;
        }
        assert (note.getLeafType() == LeafType.NOTE);
        Entity other = null;
        for (Link link : this.getLinks()) {
            if (link.getType().isInvisible() || !link.contains(note)) continue;
            if (other != null) {
                return null;
            }
            other = link.getOther(note);
            if (other.getLeafType() != LeafType.NOTE) continue;
            return null;
        }
        return other;
    }

    public boolean isRemovedIgnoreUnlinked(Entity leaf) {
        boolean result = false;
        for (HideOrShow hide : this.removed) {
            if (hide.isAboutUnlinked()) continue;
            result = hide.apply(result, leaf);
        }
        return result;
    }

    public final Entity createLeaf(Quark<Entity> quark, LeafType entityType, Set<VisibilityModifier> hides) {
        Bodier bodier = Objects.requireNonNull(entityType) == LeafType.MAP ? new BodierMap() : (Objects.requireNonNull(entityType) == LeafType.JSON ? new BodierJSon() : BodyFactory.createLeaf(entityType, hides));
        Entity result = new Entity(quark, this, bodier, entityType, this.rawLayout);
        bodier.setLeaf(result);
        return result;
    }

    public Entity createGroup(Quark<Entity> quark, GroupType groupType, Set<VisibilityModifier> hides) {
        Objects.requireNonNull(groupType);
        if (quark.getData() != null) {
            return quark.getData();
        }
        Bodier bodier = BodyFactory.createGroup(hides);
        Entity result = new Entity(quark, this, bodier, groupType, this.rawLayout);
        return result;
    }

    public Entity getRootGroup() {
        return this.rootGroup;
    }

    @Override
    public final Collection<Entity> leafs() {
        ArrayList<Entity> result = new ArrayList<Entity>();
        for (Quark<Entity> quark : this.quarks()) {
            Entity data;
            if (quark.isRoot() || (data = quark.getData()) == null || data.isGroup()) continue;
            result.add(data);
        }
        return Collections.unmodifiableCollection(result);
    }

    public final Collection<Entity> groups() {
        ArrayList<Entity> result = new ArrayList<Entity>();
        for (Quark<Entity> quark : this.quarks()) {
            Entity data;
            if (quark.isRoot() || (data = quark.getData()) == null || !data.isGroup()) continue;
            result.add(data);
        }
        return Collections.unmodifiableCollection(result);
    }

    public final Collection<Entity> groupsAndRoot() {
        ArrayList<Entity> result = new ArrayList<Entity>();
        for (Quark<Entity> quark : this.quarks()) {
            Entity data = quark.getData();
            if (data == null || !data.isGroup()) continue;
            result.add(data);
        }
        return Collections.unmodifiableCollection(result);
    }

    public void incRawLayout() {
        ++this.rawLayout;
    }

    public final List<Link> getLinks() {
        return Collections.unmodifiableList(this.links);
    }

    public void addLink(Link link) {
        if (link.isSingle() && this.containsSimilarLink(link)) {
            return;
        }
        this.links.add(link);
    }

    private boolean containsSimilarLink(Link other) {
        for (Link link : this.links) {
            if (!other.sameConnections(link)) continue;
            return true;
        }
        return false;
    }

    public void removeLink(Link link) {
        boolean ok = this.links.remove(link);
        if (!ok) {
            throw new IllegalArgumentException();
        }
    }

    public ICucaDiagram getDiagram() {
        return this.diagram;
    }

    public Collection<Quark<Entity>> quarks() {
        ArrayList<Quark<Entity>> result = new ArrayList<Quark<Entity>>();
        for (Quark<Entity> quark : this.namespace.quarks()) {
            result.add(quark);
        }
        return result;
    }

    public Quark<Entity> root() {
        return this.root;
    }

    public void setSeparator(String namespaceSeparator) {
        this.namespace.setSeparator(namespaceSeparator);
    }

    public Quark<Entity> firstWithName(String full) {
        Quark<Entity> tmp = this.namespace.firstWithName(full);
        return tmp;
    }

    public int countByName(String full) {
        return this.namespace.countByName(full);
    }
}

